% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ice.r
\name{ice}
\alias{ice}
\title{Extract the information from the simulation data frame to analyse the individual conditional expectation}
\usage{
ice(allsim, dataset, dr = seq(0, 1, 0.1), squem, remove_extrem = FALSE)
}
\arguments{
\item{allsim}{dataset with all simulations values}

\item{dataset}{dataset with all variables}

\item{dr}{a vector with dose response values}

\item{squem}{squeme of the values of the prediction values}

\item{remove_extrem}{boolean parameter to remove the extrem values}
}
\value{
a data frame with interactions
}
\description{
Extract the information from the simulation data frame to analyse the individual conditional expectation
}
\examples{
data(expose_data)
data(simu)
data(gen)
delta=c(1,0)
seku <- seq(0,1,0.05)
Exposures<- c('Var1','Var2','Var3','Var4','Var5')
summary_table_lines <- gen[[2]]
ice_res <- ice(allsim = simu[[1]], dataset = expose_data, dr = seku, 
squem = summary_table_lines, remove_extrem = FALSE)
}
