% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose_resp.r
\name{dose_resp}
\alias{dose_resp}
\title{Extract the information from the simulation data frame to analyse the dose response effects}
\usage{
dose_resp(allsim, dataset, exposures, dr, ic_dis = "IC", st)
}
\arguments{
\item{allsim}{dataset with all simulations values}

\item{dataset}{dataset with all variables}

\item{exposures}{a vector with exposures}

\item{dr}{a vector with dose response values}

\item{ic_dis}{choose between ic (interval confidences) and dis (distribution)}

\item{st}{summary table from general function}
}
\value{
a data frame with dose response values
}
\description{
Extract the information from the simulation data frame to analyse the dose response effects
}
\examples{
data(expose_data)
data(simu)
data(gen)
delta=c(1,0)
seku <- seq(0,1,0.05)
Exposures<- c('Var1','Var2','Var3','Var4','Var5')
summary_table_lines <- gen[[2]]
drr.grp <- dose_resp (allsim = simu[[1]], dataset = expose_data, st = summary_table_lines,
                      dr = seku, exposures = Exposures) 
}
