% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-data.R
\name{create_data_abtest}
\alias{create_data_abtest}
\title{Create data of A/B testing}
\usage{
create_data_abtest(
  n_a = 100,
  n_b = 100,
  success_a = 10,
  success_b = 5,
  success_unit = "count",
  count = TRUE
)
}
\arguments{
\item{n_a}{Total size of group A}

\item{n_b}{Total size of group B}

\item{success_a}{Success in group A}

\item{success_b}{Success in group B}

\item{success_unit}{Unit ("count"|"percent")}

\item{count}{Create as count-data (FALSE|TRUE)}
}
\value{
A dataset as tibble
}
\description{
Data that can be used for unit-testing or teaching
}
\examples{
library(dplyr)
create_data_abtest() \%>\% abtest()
create_data_abtest(
  n_a = 100,
  n_b = 100,
  success_a = 20,
  success_b = 30,
  success_unit = "count"
) \%>\% abtest()
}
