% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_wisle_poi_list}
\alias{get_wisle_poi_list}
\title{Compile information on worst case batches for what-if shelf life estimation}
\usage{
get_wisle_poi_list(
  icpt_list,
  model_list,
  rl,
  sl,
  srch_range,
  alpha = 0.05,
  xform = c("no", "no"),
  shift = c(0, 0),
  ivl = "confidence",
  ivl_type = "one.sided",
  ivl_side = "lower",
  ...
)
}
\arguments{
\item{icpt_list}{A list of four elements named \code{cics}, \code{dics},
\code{dids.pmse} and \code{dids} with the intercepts of each linear
regression model and batch. The \code{cics}, \code{dics} and
\code{dids.pmse} elements are \code{NA} if data of only a single batch
is available.}

\item{model_list}{A list of regression models of different type. Usually,
it is a list of four elements named \code{cics}, \code{dics},
\code{dids.pmse} and \code{dids}, where the first three elements contain
\sQuote{\code{lm}} objects of the \dQuote{common intercept / common slope}
(\code{cics}), \dQuote{different intercept / common slope} (\code{dics})
and \dQuote{different intercept / different slope} (\code{dids.pmse}) type.
The fourth element with the label \code{dids} is usually a list of the
\sQuote{\code{lm}} objects that is obtained from fitting a regression
model to the data of each level of the categorical variable separately.
The \code{dids.pmse} model differs from the \code{dids} model in that it
is a model with the categorical variable as a fixed main effect and with
an interaction term of the categorical variable with the time variable,
i.e. a model where the mean square error is pooled across batches (thus
the \dQuote{pmse} suffix meaning \dQuote{pooled mean square error}). The
\code{cics}, \code{dics} and \code{dids.pmse} elements are \code{NA} if
data of only a single batch is available.}

\item{rl}{A numeric value or a numeric vector that specifies the release
specification limit(s) for which the corresponding expiry should be
estimated.}

\item{sl}{A numeric value or a numeric vector of length \code{2} that
specifies the specification limit or limits. If a vector is provided it
must be of the form \code{c(lower limit, upper limit)}.}

\item{srch_range}{A vector of length \code{2} that specifies the end-points
of the (time) range that is supposed to contain the shelf life or retest
period.}

\item{alpha}{A numeric value between 0 and 1 that specifies the significance
level for the calculation of confidence or prediction intervals. The
default is \code{0.05}.}

\item{xform}{A vector of two character strings that specifies the
transformation of the response and the time variable. The default is
\dQuote{no} transformation, i.e. \code{c("no", "no")}, where the first
element specifies the transformation of the \eqn{x} variable and the
second element the transformation of the \eqn{y} variable. Valid
alternatives for \eqn{x} and/or \eqn{y} variable transformation are
\code{"log"} (natural logarithm), \code{"sqrt"} (square root) and
\code{"sq"} (square).}

\item{shift}{A vector of two values which will be added to the variables
\eqn{x} and/or \eqn{y} before they are transformed as specified by the
\code{xform} parameter, where the first element will be added to the
\eqn{x} variable and the second element to the \eqn{y} variable. The
purpose is to prevent an undefined state which could arise when variables
with values of \eqn{\leq 0} are log or square root transformed. The
default is \code{c(0, 0)}.}

\item{ivl}{A character string of either \code{"confidence"} or
\code{"prediction"} that specifies the type of interval of interest.
The default is \code{"confidence"}.}

\item{ivl_type}{A character string that specifies if a \dQuote{one sided}
or a \dQuote{two sided} interval should be calculated, i.e. either
\code{"one.sided"} or \code{"two.sided"}, respectively. The default is
\code{"one.sided"}.}

\item{ivl_side}{A character string that specifies if the \dQuote{upper} or
the \dQuote{lower} limit is the relevant limit, i.e. either \code{"upper"}
or \code{"lower"}, respectively. The default is \code{"lower"}. Since this
parameter additionally specifies the relationship of \code{rl} with
\code{sl}, i.e. which of the two sides of \code{sl} the \code{rl} is
compared to, only either either \code{"upper"} or \code{"lower"} is
possible. In this respect, the usage of \code{ivl_side} differs from its
usage in the \code{expirest_osle()} function where \code{ivl_side} in
addition can be \code{"both"}.}

\item{...}{Additional named or unnamed arguments passed on to
\code{uniroot()}.}
}
\value{
A list with the following elements is returned:
\item{all.wcsl}{A list of the worst case scenario (wcs) limits with a list
  of four elements for each linear model named \code{cics}, \code{dics},
  \code{dids.pmse} and \code{dids}. Each of these elements contains a list
  element for each batch (intercept) containing itself a list element for
  each release limit. The wcs limit is obtained by adding/subtracting the
  absolute difference of specification limit and release limit to/from the
  common intercept of the test batches or the intercept of the worst
  performing batch.}
\item{all.poi}{A list of the POI values, i.e. a list with a list of four
  elements for each linear model named \code{cics}, \code{dics},
  \code{dids.pmse} and \code{dids}. Each of these elements contains a
  matrix with columns for each intercept and rows for each release limit.}
\item{all.prl}{A list of the confidence or prediction interval limits that
  are associated with a POI value, i.e. a list with a list of four elements
  for each linear model named \code{cics}, \code{dics}, \code{dids.pmse}
  and \code{dids}. Each of these elements contains an array with a level for
  each batch, containing matrices with columns for each batch and rows for
  each release limit, where the matrices contain the estimated interval
  limits at each POI value per batch.}
\item{which.min.dist}{A list of four elements for each linear model named
  \code{cics}, \code{dics}, \code{dids.pmse} and \code{dids}. Each of these
  list elements contains a matrix of the indices of the batches with the
  minimal intercept in the \code{all.prl} list. The matrices have a column
  for each batch and a row for each release limit.}
\item{which.min.poi}{A list of four elements for each linear model named
  \code{cics}, \code{dics}, \code{dids.pmse} and \code{dids}. Each of these
  list elements contains a numeric vector with the minimal POI value of
  associated with each release limit.}
\item{which.wc.batch}{A list of four elements for each linear model named
  \code{cics}, \code{dics}, \code{dids.pmse} and \code{dids}. Each of these
  list elements contains a numeric vector with the indices of the worst
  case batches associated with each release limit.}
}
\description{
The function \code{get_wisle_poi_list()} prepares a list of points of
intersection (POI) for multiple regression models and release limits
using the \code{find_poi()} function.
}
\details{
The function \code{get_wisle_poi_list()} applies the
\code{find_poi()} function (find the \dQuote{point of intersection}) on
all the models and for each release limit (\code{rl}) provided. With respect
to the latter it differs from the \code{\link{get_poi_list}()} function.
}
\seealso{
\code{\link{get_icpt_list}}, \code{\link{get_model_list}},
\code{\link{get_wcs_limit}}, \code{\link{find_poi}},
\code{\link{get_intvl_limit}}, \code{\link{expirest_osle}},
\code{\link{expirest_wisle}}.
}
\keyword{internal}
