% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgaps_methods.R
\name{dgaps_methods}
\alias{dgaps_methods}
\alias{coef.dgaps}
\alias{vcov.dgaps}
\alias{nobs.dgaps}
\alias{logLik.dgaps}
\alias{print.dgaps}
\alias{summary.dgaps}
\alias{print.summary.dgaps}
\title{Methods for objects of class \code{"dgaps"}}
\usage{
\method{coef}{dgaps}(object, ...)

\method{vcov}{dgaps}(object, type = c("observed", "expected"), ...)

\method{nobs}{dgaps}(object, ...)

\method{logLik}{dgaps}(object, ...)

\method{print}{dgaps}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{summary}{dgaps}(
  object,
  se_type = c("observed", "expected"),
  digits = max(3, getOption("digits") - 3L),
  ...
)

\method{print}{summary.dgaps}(x, ...)
}
\arguments{
\item{object}{and object of class \code{c("dgaps", "exdex")} returned from
\code{\link{dgaps}}.}

\item{...}{For \code{print.summary.dgaps}, additional arguments passed to
\code{\link{print.default}}.}

\item{type}{A character scalar. Should the estimate of the variance be based
on the observed information or the expected information?}

\item{x}{\code{print.dgaps}. An object of class \code{c("dgaps", "exdex")}, a
  result of a call to \code{\link{dgaps}}.

  \code{print.summary.dgaps}. An object of class \code{"summary.dgaps"}, a
  result of a call to \code{\link{summary.dgaps}}.}

\item{digits}{\code{print.dgaps}. The argument \code{digits} to
  \code{\link{print.default}}.

  \code{summary.dgaps}. An integer. Used for number formatting with
  \code{\link[base:Round]{signif}}.}

\item{se_type}{A character scalar. Should the estimate of the standard error
be based on the observed information or the expected information?}
}
\value{
\code{coef.dgaps}. A numeric scalar: the estimate of the extremal index
  \eqn{\theta}.

  \code{vcov.dgaps}. A \eqn{1 \times 1}{1 x 1} numeric matrix containing the
  estimated variance of the estimator.

  \code{nobs.dgaps}. A numeric scalar: the number of inter-exceedance times
  used in the fit. If \code{x$inc_cens = TRUE} then this includes up to 2
  censored observations.

  \code{logLik.dgaps}. An object of class \code{"logLik"}: a numeric scalar
  with value equal to the maximised log-likelihood.  The returned object
  also has attributes \code{nobs}, the numbers of \eqn{K}-gaps that
  contribute to the log-likelihood and \code{"df"}, which is equal to the
  number of total number of parameters estimated (1).

  \code{print.dgaps}. The argument \code{x}, invisibly.

  \code{summary.dgaps}. Returns a list containing the list element
  \code{object$call} and a numeric matrix \code{summary} giving the estimate
  of the extremal index \eqn{\theta} and the estimated standard error
  (Std. Error).

  \code{print.summary.dgaps}. The argument \code{x}, invisibly.
}
\description{
Methods for objects of class \code{c("dgaps", "exdex")} returned from
\code{\link{dgaps}}.
}
\section{Examples}{

See the examples in \code{\link{dgaps}}.
}

\seealso{
\code{\link{dgaps}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{K}-gaps model.

\code{\link{confint.dgaps}} for confidence intervals for
  \eqn{\theta}.
}
