% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_methods.R
\name{spm_methods}
\alias{spm_methods}
\alias{coef.spm}
\alias{vcov.spm}
\alias{nobs.spm}
\alias{print.spm}
\alias{summary.spm}
\alias{print.summary.spm}
\title{Methods for objects of class \code{"spm"}}
\usage{
\method{coef}{spm}(
  object,
  maxima = c("sliding", "disjoint"),
  estimator = "all",
  constrain = FALSE,
  ...
)

\method{vcov}{spm}(object, maxima = c("sliding", "disjoint"), estimator = "all", ...)

\method{nobs}{spm}(object, maxima = c("sliding", "disjoint"), ...)

\method{print}{spm}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{summary}{spm}(object, digits = max(3, getOption("digits") - 3L), ...)

\method{print}{summary.spm}(x, ...)
}
\arguments{
\item{object}{an object of class \code{"spm"}, a result of a call to
\code{\link{spm}}.}

\item{maxima}{A character scalar specifying whether to return the
number of observed sliding maxima or disjoint maxima.}

\item{estimator}{A character vector specifying which of the three variants
of the semiparametric maxima estimator to use: \code{"N2015", "BB2018"}
or \code{"BB2018b"}. See \code{\link{spm}} for details. If
\code{estimator = "all"} then the estimated variances of all variants are
returned.}

\item{constrain}{A logical scalar.  If \code{constrain = TRUE} then
any estimates that are greater than 1 are set to 1,
that is, they are constrained to lie in (0, 1].  Otherwise,
estimates that are greater than 1 may be obtained.}

\item{...}{For \code{print.summary.spm}, additional arguments passed to
\code{\link{print.default}}.}

\item{x}{\code{print.spm}. An object of class \code{c("spm", "exdex")}, a
  result of a call to \code{\link{spm}}.

  \code{print.summary.spm}. An object of class \code{"summary.spm"}, a
  result of a call to \code{\link{summary.spm}}.}

\item{digits}{An integer. Used for number formatting with
\code{\link[base:Round]{signif}}.}
}
\value{
\code{coef.spm}. A numeric scalar (or a vector of length 3 if
  \code{estimator = "all"}): the required estimate(s) of the extremal index
  \eqn{\theta}.

  \code{vcov.spm}. A \eqn{1 \times 1}{1 x 1} numeric matrix if
  \code{estimator = "N2015"} or \code{"BB2018"} and a vector of length 3 if
  \code{estimator = "all"}, containing the estimated variance(s) of the
  estimator(s).

  \code{nobs.spm}. A numeric scalar: the number of observations used in the
  fit.

  \code{print.spm}. The argument \code{x}, invisibly.

  \code{summary.spm}. Returns an object (a list) of class
  \code{"summary.spm"} containing the list element \code{object$call} and a
  numeric matrix \code{matrix} giving, for all three variants of the
  semiparametric estimator and both sliding and disjoint blocks,
  the (bias-adjusted) Estimate of the extremal index \eqn{\theta},
  the estimated standard error (Std. Error),
  and the bias adjustment (Bias adj.) applied to obtain the estimate, i.e.
  the value subtracted from the raw estimate.  If any of the
  (bias-adjusted) estimates are greater than 1 then a column
  containing the unconstrained estimates (Uncon. estimate) is added.

  \code{print.summary.spm}. The argument \code{x}, invisibly.
}
\description{
Methods for objects of class \code{c("spm", "exdex")} returned from
\code{\link{spm}}.
}
\details{
\code{print.spm} prints the original call to \code{\link{spm}}
  and the estimates of the extremal index \eqn{\theta}, based on all three
  variants of the semiparametric maxima estimator and both sliding
  and disjoint blocks.
}
\section{Examples}{

See the examples in \code{\link{spm}}.
}

\seealso{
\code{\link{spm}} for semiparametric estimation of the
  extremal index based on block maxima.
}
