% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iwls_methods.R
\name{print.iwls}
\alias{print.iwls}
\title{Print method for an \code{"iwls"} object}
\usage{
\method{print}{iwls}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{an object of class \code{c("iwls", "exdex")}, a result of
a call to \code{\link{iwls}}.}

\item{digits}{The argument \code{digits} to \code{\link{print.default}}.}

\item{...}{Additional arguments.  None are used in this function.}
}
\value{
The argument \code{x}, invisibly, as for all
  \code{\link[base]{print}} methods.
}
\description{
\code{print} method for class \code{c("iwls", "exdex")}.
}
\details{
Prints the original call to \code{\link{iwls}}
  and the estimate of the extremal index \eqn{\theta}.
}
\seealso{
\code{\link{iwls}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{K}-gaps model.
}
