% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ep.R
\name{exceedProb}
\alias{exceedProb}
\title{Confidence intervals for the exceedance probability}
\usage{
exceedProb(cutoff, theta_hat, sd_hat, alpha, d, n, m, interval = c(-100,
  100), lower_tail = FALSE)
}
\arguments{
\item{cutoff}{Cutoff values (scalar or vector)}

\item{theta_hat}{Point estimate for the parameter of interest}

\item{sd_hat}{Estimated standard deviation for the parameter of interest (Note: not the standard error)}

\item{alpha}{Significance level}

\item{d}{Number of parameters in the general linear model}

\item{n}{Number of observations in the initial study}

\item{m}{Number of observations in the replication study}

\item{interval}{Interval within which to search for roots}

\item{lower_tail}{If TRUE, reports lower tail probabilities}
}
\value{
ep Exceedance probability with confidence intervals
}
\description{
This function obtains confidence intervals for exceedance probability
}
\examples{
library(exceedProb)

# Sample mean -------------------------------------------------------
n <- 100
x <- rnorm(n = n)

theta_hat <- mean(x)
sd_hat <- sd(x)

cutoff <- seq(from = theta_hat - 0.5, to = theta_hat + 0.5, by = 0.1)

exceedProb(cutoff = cutoff, 
           theta_hat = theta_hat, 
           sd_hat = sd_hat, 
           alpha = 0.05, 
           d = 1,
           n = n,
           m = n)

# Linear regression -------------------------------------------------
n <- 100
beta <- c(1, 2)
x <-runif(n = n, min = 0, max = 10)
y <- rnorm(n = n, mean = cbind(1, x) \%*\% beta, sd = 1)

j <- 2
fit <- lm(y ~ x)
theta_hat <- coef(fit)[j]
sd_hat <- sqrt(n * vcov(fit)[j, j])

cutoff <- seq(from = theta_hat - 0.5, to = theta_hat + 0.5, by = 0.1)

exceedProb(cutoff = cutoff, 
           theta_hat = theta_hat, 
           sd_hat = sd_hat, 
           alpha = 0.05, 
           d = length(beta),
           n = n,
           m = n)
}
