% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spell.R
\name{spell}
\alias{spell}
\alias{rm_spell_check}
\title{RMarkdown Spell Check}
\usage{
spell(
  path,
  ignore = c("Meta", "information", "extype", "num", "mchoice", "schoice", "Solution",
    "exsolution", "extol", "exname", "Question", "align", "begin", "bigg", "cases",
    "cdot", "end", "frac", "infty", "int", "left", "left.", "leq", "mu", "qquad",
    "right", "sum", "text", "vert"),
  lang = Sys.getenv("LANG")
)

rm_spell_check(
  path,
  ignore = c("Meta", "information", "extype", "num", "mchoice", "schoice", "Solution",
    "exsolution", "extol", "exname", "Question", "align", "begin", "bigg", "cases",
    "cdot", "end", "frac", "infty", "int", "left", "left.", "leq", "mu", "qquad",
    "right", "sum", "text", "vert"),
  lang = Sys.getenv("LANG")
)
}
\arguments{
\item{path}{path to file or to spell check}

\item{ignore}{character vector with words which will be added to the \link[hunspell:hunspell]{hunspell::dictionary}}

\item{lang}{set \code{Language} field in \code{DESCRIPTION} e.g. \code{"en-US"} or \code{"en-GB"}.
For supporting other languages, see the \href{https://docs.ropensci.org/hunspell/articles/intro.html#hunspell-dictionaries}{hunspell vignette}.}
}
\value{
A data frame with problematic words.
}
\description{
Performs a spell check on RMarkdown files ignoring some \code{exams} keywords using \code{\link[spelling:spell_check_files]{spelling::spell_check_files()}}.
}
\examples{
# none
}
