% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch08BNM.R
\name{BNM}
\alias{BNM}
\title{Bayesian Network Model}
\usage{
BNM(
  U,
  Z = NULL,
  w = NULL,
  na = NULL,
  g = NULL,
  adj_file = NULL,
  adj_matrix = NULL
)
}
\arguments{
\item{U}{U is either a data class of exametrika, or raw data. When raw data is given,
it is converted to the exametrika class with the \link{dataFormat} function.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{g}{Specify a graph object suitable for the igraph class.}

\item{adj_file}{specify CSV file where the graph structure is specified.}

\item{adj_matrix}{specify adjacency matrix.}
}
\value{
\describe{
\item{nobs}{Sample size. The number of rows in the dataset.}
\item{testlength}{Length of the test. The number of items included in the test.}
\item{crr}{correct response ratio}
\item{TestFitIndices}{Overall fit index for the test.See also \link{TestFit}}
\item{adj}{Adjacency matrix}\
\item{param}{Learned Parameters}
\item{CCRR_table}{Correct Response Rate tables}
}
}
\description{
performs Bayesian Network Model with specified graph structure
}
\details{
This function performs a Bayesian network analysis on the relationships
between items. This corresponds to Chapter 8 of the text. It uses the igraph
package for graph visualization and checking the adjacency matrix.
You need to provide either a graph object or a CSV file where the graph
structure is specified.
}
\examples{
\donttest{
# Create a Directed Acyclic Graph (DAG) structure for item relationships
# Each row represents a directed edge from one item to another
DAG <-
  matrix(
    c(
      "Item01", "Item02", # Item01 influences Item02
      "Item02", "Item03", # Item02 influences Item03
      "Item02", "Item04", # Item02 influences Item04
      "Item03", "Item05", # Item03 influences Item05
      "Item04", "Item05" # Item04 influences Item05
    ),
    ncol = 2, byrow = TRUE
  )

# Convert the DAG matrix to an igraph object for network analysis
g <- igraph::graph_from_data_frame(DAG)
g

# Create adjacency matrix from the graph
# Shows direct connections between items (1 for connection, 0 for no connection)
adj_mat <- as.matrix(igraph::as_adjacency_matrix(g))
print(adj_mat)

# Fit Bayesian Network Model using the specified adjacency matrix
# Analyzes probabilistic relationships between items based on the graph structure
result.BNM <- BNM(J5S10, adj_matrix = adj_mat)
result.BNM
}

}
