% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch11BINET.R
\name{BINET}
\alias{BINET}
\title{Bicluster Network Model}
\usage{
BINET(
  U,
  Z = NULL,
  w = NULL,
  na = NULL,
  conf = NULL,
  ncls = NULL,
  nfld = NULL,
  g_list = NULL,
  adj_list = NULL,
  adj_file = NULL,
  verbose = FALSE
)
}
\arguments{
\item{U}{U is either a data class of exametrika, or raw data. When raw data is given,
it is converted to the exametrika class with the \link{dataFormat} function.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{conf}{For the confirmatory parameter, you can input either a vector with
items and corresponding fields in sequence, or a field membership profile
matrix. In the case of the former, the field membership profile matrix will be generated internally.
When providing a membership profile matrix, it needs to be either matrix or data.frame.
The number of fields(nfld) will be overwrite to the number of columns of this matrix.}

\item{ncls}{number of classes}

\item{nfld}{number of fields}

\item{g_list}{A list compiling graph-type objects for each rank/class.}

\item{adj_list}{A list compiling matrix-type adjacency matrices for each rank/class.}

\item{adj_file}{A file detailing the relationships of the graph for each rank/class,
listed in the order of starting point, ending point, and rank(class).}

\item{verbose}{verbose output Flag. default is TRUE}
}
\value{
\describe{
\item{nobs}{Sample size. The number of rows in the dataset.}
\item{testlength}{Length of the test. The number of items included in the test.}
\item{Nclass}{Optimal number of classes.}
\item{Nfield}{Optimal number of fields.}
\item{crr}{Correct Response Rate}
\item{ItemLabel}{Label of Items}
\item{FieldLabel}{Label of Fields}
\item{all_adj}{Integrated Adjacency matrix used to plot graph.}
\item{all_g}{Integrated graph object used to plot graph.see also
\link{plot.exametrika}}
\item{adj_list}{List of Adjacency matrix used in the model}
\item{params}{A list of the estimated conditional probabilities.
It indicates which path was obtained from which parent node(class) to
which child node(class), held by \code{parent}, \code{child}, and \code{field}. The item
Items contained in the field is in \code{fld}. Named \code{chap} includes the
conditional correct response answer rate of the child node, while \code{pap}
contains the pass rate of the parent node.}
\item{PSRP}{Response pattern by the students belonging to the parent
classes of Class c. A more comprehensible arrangement of \code{params.}}
\item{LCD}{Latent Class Distribution. see also \link{plot.exametrika}}
\item{LFD}{Latent Field Distribution. see also \link{plot.exametrika}}
\item{CMD}{Class Membership Distribution.}
\item{FRP}{Marginal bicluster reference matrix.}
\item{FRPIndex}{Index of FFP includes the item location parameters B and Beta,
the slope parameters A and Alpha, and the monotonicity indices C and Gamma.}
\item{TRP}{Test Reference Profile}
\item{LDPSR}{A rearranged set of parameters for output. It includes
the field the items contained within that field, and the conditional
correct response rate of parent nodes(class) and child node(class).}
\item{FieldEstimated}{Given vector which correspondence between items
and the fields.}
\item{Students}{Rank Membership Profile matrix.The s-th row vector of \eqn{\hat{M}_R}, \eqn{\hat{m}_R}, is the
rank membership profile of Student s, namely the posterior probability distribution representing the student's
belonging to the respective latent classes. }
\item{NextStage}{The next class that easiest for students to move to,
its membership probability, class-up odds, and the field required for
more.}
\item{MG_FitIndices}{Multigroup as Null model.See also \link{TestFit}}
\item{SM_FitIndices}{Saturated Model as Null model.See also \link{TestFit}}
}
}
\description{
Bicluster Network Model: BINET is a model that combines the Bayesian
network model and Biclustering. BINET is very similar to LDB and LDR.
The most significant difference is that in LDB, the nodes represent
the fields, whereas in BINET, they represent the class. BINET
explores the local dependency structure among latent classes at each
latent field, where each field is a locus.
}
\examples{
\donttest{
# Example: Bicluster Network Model (BINET)
# BINET combines Bayesian network model and Biclustering to explore
# local dependency structure among latent classes at each field

# Create field configuration vector based on field assignments
conf <- c(
  1, 5, 5, 5, 9, 9, 6, 6, 6, 6, 2, 7, 7, 11, 11, 7, 7,
  12, 12, 12, 2, 2, 3, 3, 4, 4, 4, 8, 8, 12, 1, 1, 6, 10, 10
)

# Create edge data for network structure between classes
edges_data <- data.frame(
  "From Class (Parent) >>>" = c(
    1, 2, 3, 4, 5, 7, 2, 4, 6, 8, 10, 6, 6, 11, 8, 9, 12
  ),
  ">>> To Class (Child)" = c(
    2, 4, 5, 5, 6, 11, 3, 7, 9, 12, 12, 10, 8, 12, 12, 11, 13
  ),
  "At Field (Locus)" = c(
    1, 2, 2, 3, 4, 4, 5, 5, 5, 5, 5, 7, 8, 8, 9, 9, 12
  )
)

# Save edge data to temporary CSV file
tmp_file <- tempfile(fileext = ".csv")
write.csv(edges_data, file = tmp_file, row.names = FALSE)

# Fit Bicluster Network Model
result.BINET <- BINET(
  U = J35S515,
  ncls = 13, # Maximum class number from edges (13)
  nfld = 12, # Maximum field number from conf (12)
  conf = conf, # Field configuration vector
  adj_file = tmp_file # Path to the CSV file
)

# Clean up temporary file
unlink(tmp_file)

# Display model results
print(result.BINET)

# Visualize different aspects of the model
plot(result.BINET, type = "Array") # Show bicluster structure
plot(result.BINET, type = "TRP") # Test Response Profile
plot(result.BINET, type = "LRD") # Latent Rank Distribution
plot(result.BINET,
  type = "RMP", # Rank Membership Profiles
  students = 1:9, nc = 3, nr = 3
)
plot(result.BINET,
  type = "FRP", # Field Reference Profiles
  nc = 3, nr = 2
)
plot(result.BINET,
  type = "LDPSR", # Locally Dependent Passing Student Rates
  nc = 3, nr = 2
)
}
}
