% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fns.R
\name{run_matrix_checks}
\alias{run_matrix_checks}
\title{Automated checks for a set of matrices}
\usage{
run_matrix_checks(Aobj)
}
\arguments{
\item{Aobj}{An object containing the population projection matrices to be
included in the analysis. It should either be a list, or a matrix where each
row is the column-wise vectorization of a matrix.}
}
\value{
If all the checks pass, then nothing is returned. If one of the checks
fails, then an error or warning message will be returned.
}
\description{
Run automated checks for a set of population projection matrices. This code will
check if the matrices are square, strictly non-negative, ergodic, irreducible,
and primitive. The last check is for whether the column sums are greater than 1
for presumed survival terms. For this portion, the code assumes that the first
row represents only fertility, and that all other matrix entries represent
only survival.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
run_matrix_checks(list(A1,A2,A3))
# A couple of examples that would throw errors or warnings:
# run_matrix_checks(c(0,0.8,0, -1,0,0.7, 5,0,0.2)) # has a negative value
# run_matrix_checks(c(0,0.8,0, 0,0.5,0.7, 5,0,0.2)) # has a column-sum greater than 1
}
