% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{power.image}
\alias{power.image}
\title{Image plot of power}
\usage{
power.image(data, p = 0.2, binary = TRUE, beta = 0.75)
}
\arguments{
\item{data}{a matrix of powers with columns named beta p0.vals, n0 and n1.}

\item{p}{a scalar value for p0.vals that is used to select the subset of data.}

\item{binary}{If TRUE only the binary indicator of power exceeding beta is displayed.}

\item{beta}{target value of power}
}
\value{
No return value and if the 'binary' parameter is TRUE then an image will be displayed
}
\description{
Creates image plot of exact power for range of values of n0 and n1.
Optionally, the image plot will show where power exceeds a provided power
target.
}
\details{
data will be one of the 85 saved objects corresponding to a selected value
of alpha and delta.
}
\examples{
oldpar <- graphics::par()
# Load toy version of power library for alpha=0.025, delta=0.20.
rdata_file = system.file('files', 'LIB.a025.d20.Rdata', package = 'exact.n')
load(rdata_file)
graphics::par(mfrow=c(1,2))
power.image(LIB.a025.d20,p=.5,binary=FALSE)
power.image(LIB.a025.d20,p=.2,beta=.7,binary=TRUE)
suppressWarnings(graphics::par(oldpar))
}
\author{
Chris J. Lloyd
}
