% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classic_ewoc.R
\name{ewoc_d1classic}
\alias{ewoc_d1classic}
\title{Escalation With Overdose Control}
\usage{
ewoc_d1classic(formula, theta, alpha, mtd_prior, rho_prior, min_dose, max_dose,
  type = c("continuous", "discrete"), first_dose = NULL, last_dose = NULL,
  dose_set = NULL, rounding = c("down", "nearest"), n_adapt = 5000,
  burn_in = 1000, n_mcmc = 1000, n_thin = 1, n_chains = 1)
}
\arguments{
\item{formula}{an object of class \code{\link[Formula]{Formula}}: a symbolic
description of the model to be fitted with only one regressor term
corresponding to the dose for the right side and a numeric vector a response
containing number of DLT for the left side.}

\item{theta}{a numerical value defining the proportion of expected patients
to experience a medically unacceptable, dose-limiting toxicity (DLT) if
administered the MTD.}

\item{alpha}{a numerical value defining the probability that the dose selected
by EWOC is higher than the MTD.}

\item{mtd_prior}{a matrix 1 x 2 of hyperparameters for the Beta prior
distribution associated with the parameter MTD.}

\item{rho_prior}{a matrix 1 x 2 of hyperparameters for the Beta prior distribution
associated with the parameter rho.}

\item{min_dose}{a numerical value defining the lower bound of the support of
the MTD.}

\item{max_dose}{a numerical value defining the upper bound of the support of
the MTD.}

\item{type}{a character describing the type of the Maximum Tolerable Dose
(MTD) variable.}

\item{first_dose}{a numerical value for the first allowable dose in the trial.
It is only necessary if type = 'continuous'.}

\item{last_dose}{a numerical value for the last allowable dose in the trial.
It is only necessary if type = 'continuous'.}

\item{dose_set}{a numerical vector of allowable doses in the trial.
It is only necessary if type = 'discrete'.}

\item{rounding}{a character indicating how to round a continuous dose to the
one of elements of the dose set. It is only necessary if type = 'discrete'.}

\item{n_adapt}{the number of iterations for adaptation.
See \code{\link[rjags]{adapt}} for details.}

\item{burn_in}{numerical value indicating the number of iterations before to start monitoring.}

\item{n_mcmc}{numerical value indicating the number of iterations to monitor.}

\item{n_thin}{numerical value corresponding to the thinning interval for monitors.}

\item{n_chains}{numerical value indicating the number of parallel chains for the model.}
}
\value{
\code{next_dose} the next recommend dose.

\code{mtd} the posterior MTD distribution.

\code{rho} the posterior rho_0 distribution.

\code{sample} a list of the MCMC chains distribution.

\code{trial} a list of the trial conditions.
}
\description{
Finding the next dose for a phase I clinical trial based on the
Escalation with Overdose Control (EWOC) design considering the
classic parametrization for binary responses and single agent.
}
\examples{
DLT <- 0
dose <- 30
test <- ewoc_d1classic(DLT ~ dose, type = 'discrete',
                      theta = 0.33, alpha = 0.25,
                      min_dose = 0, max_dose = 100,
                      dose_set = seq(0, 100, 20),
                      rho_prior = matrix(1, ncol = 2, nrow = 1),
                      mtd_prior = matrix(1, ncol = 2, nrow = 1),
                      rounding = "nearest")
summary(test)
plot(test)

}
\references{
Babb, J., Rogatko, A. and Zacks, S., 1998.
Cancer phase I clinical trials: efficient dose escalation with overdose
control. Statistics in medicine, 17(10), pp.1103-1120.
}
