% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charging_infrastructure.R
\name{plot_occupancy_duration_curve}
\alias{plot_occupancy_duration_curve}
\title{Plot the occupancy duration curve}
\usage{
plot_occupancy_duration_curve(
  sessions,
  dttm_seq = NULL,
  by = "Profile",
  resolution = 15,
  mc.cores = 1
)
}
\arguments{
\item{sessions}{tibble, sessions data set in standard format marked by \code{{evprof}} package
(see \href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{this article})}

\item{dttm_seq}{sequence of datetime values that will be the \code{datetime}
variable of the returned time-series data frame.}

\item{by}{character, being 'Profile' or 'Session'. When \code{by='Profile'} each column corresponds to an EV user profile.}

\item{resolution}{integer, time resolution (in minutes) of the sessions datetime variables.
If \code{dttm_seq} is defined this parameter is ignored.}

\item{mc.cores}{integer, number of cores to use.
Must be at least one, and parallelization requires at least two cores.}
}
\value{
ggplot
}
\description{
This term is based on the "load duration curve" and is useful to see the
behavior of occupancy over the time in your charging installation.
The steeper the curve, the shorter the duration that higher number of connections
are sustained. Conversely, the flatter the curve, the longer the duration that
higher number of connections are sustained.
This information is crucial for various purposes, such as infrastructure planning,
capacity sizing, and resource allocation.
}
\examples{
library(dplyr)

sessions <- head(evsim::california_ev_sessions_profiles, 100)
plot_occupancy_duration_curve(
  sessions,
  by = "Profile",
  resolution = 15
)

}
