% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcR2CvCorrected.R
\name{CalcR2CvCorrected}
\alias{CalcR2CvCorrected}
\alias{CalcR2CvCorrected.default}
\alias{CalcR2CvCorrected.lm}
\title{Corrected integration value}
\usage{
CalcR2CvCorrected(ind.data, ...)

\method{CalcR2CvCorrected}{default}(
  ind.data,
  cv.level = 0.06,
  iterations = 1000,
  parallel = FALSE,
  ...
)

\method{CalcR2CvCorrected}{lm}(ind.data, cv.level = 0.06, iterations = 1000, ...)
}
\arguments{
\item{ind.data}{Matrix of individual measurments, or adjusted linear model}

\item{...}{additional arguments passed to other methods}

\item{cv.level}{Coefficient of variation level chosen for integration index adjustment in linear model. Defaults to 0.06.}

\item{iterations}{Number of resamples to take}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
List with adjusted integration indexes, fitted models and simulated distributions of integration indexes and mean coefficient of variation.
}
\description{
Calculates the Young correction for integration, using bootstrap resampling
}
\examples{
\dontrun{
integration.dist = CalcR2CvCorrected(iris[,1:4])

#adjusted values
integration.dist[[1]]

#ploting models
library(ggplot2)
ggplot(integration.dist$dist, aes(r2, mean_cv)) + geom_point() + 
       geom_smooth(method = 'lm', color= 'black') + theme_bw()
       
ggplot(integration.dist$dist, aes(eVals_cv, mean_cv)) + geom_point() + 
       geom_smooth(method = 'lm', color= 'black') + theme_bw()
}
}
\references{
Young, N. M., Wagner, G. P., and Hallgrimsson, B. (2010).
Development and the evolvability of human limbs. Proceedings of the
National Academy of Sciences of the United States of America, 107(8),
3400-5. doi:10.1073/pnas.0911856107
}
\seealso{
\code{\link{MeanMatrixStatistics}}, \code{\link{CalcR2}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{correlation}
\keyword{integration}
