% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhyloW.R
\name{PhyloW}
\alias{PhyloW}
\title{Calculates ancestral states of some statistic}
\usage{
PhyloW(tree, tip.data, tip.sample.size = NULL)
}
\arguments{
\item{tree}{phylogenetic tree}

\item{tip.data}{list of tip nodes covariance matrices}

\item{tip.sample.size}{vector of tip nodes sample sizes}
}
\value{
list with calculated within-group matrices, using labels or numbers from tree
}
\description{
Calculates weighted average of covariances matrices along a phylogeny, returning a withing-group covariance matrice for each node.
}
\examples{
library(ape)
data(dentus)
data(dentus.tree)
tree <- dentus.tree
mat.list <- dlply(dentus, 'species', function(x) cov(x[,1:4]))
sample.sizes <- runif(length(tree$tip.label), 15, 20)
PhyloW(tree, mat.list, sample.sizes)
}

