\name{DT_wheat}
\alias{DT_wheat}
\alias{GT_wheat}
\alias{A_wheat}
\title{wheat lines dataset}
\description{

Information from a collection of 599 historical CIMMYT wheat lines.  The wheat data set is from 
CIMMYT's Global Wheat Program. Historically, this program has conducted numerous international 
trials across a wide variety of wheat-producing environments. The environments represented in 
these trials were grouped into four basic target sets of environments comprising four 
main agroclimatic regions previously defined and widely used by CIMMYT's Global Wheat Breeding Program. 
The phenotypic trait considered here was the average grain yield (GY) of the 599 wheat lines evaluated 
in each of these four mega-environments. 

A pedigree tracing back many generations was available, and the Browse application of 
the International Crop Information System (ICIS), as described in  (McLaren \emph{et al.} 2000, 2005) was used 
for deriving the relationship matrix A among the 599 lines; it accounts for selection and inbreeding.

Wheat lines were recently genotyped using 1447 Diversity Array Technology (DArT) generated by 
Triticarte Pty. Ltd. (Canberra, Australia; http://www.triticarte.com.au). The DArT markers 
may take on two values, denoted by their presence or absence. Markers with a minor allele frequency 
lower than 0.05 were removed, and missing genotypes were imputed with samples from the marginal 
distribution of marker genotypes, that is, \eqn{x_{ij}=Bernoulli(\hat p_j)}, where  \eqn{\hat p_j}  
is the estimated allele frequency computed from the non-missing genotypes. The number of DArT 
MMs after edition was 1279.

}

\usage{
  data(DT_wheat)
}

\format{
 Matrix Y contains the average grain yield, column 1: Grain yield for environment 1 and so on. 
}

\source{
  International Maize and Wheat Improvement Center (CIMMYT), Mexico.
}

\references{

Giovanny Covarrubias-Pazaran (2024).  evola: a simple evolutionary algorithm for complex problems. To be submitted to Bioinformatics.

Gaynor, R. Chris, Gregor Gorjanc, and John M. Hickey. 2021. AlphaSimR: an R package for breeding program simulations. G3 Gene|Genomes|Genetics 11(2):jkaa017. https://doi.org/10.1093/g3journal/jkaa017.

Chen GK, Marjoram P, Wall JD (2009). Fast and Flexible Simulation of DNA Sequence Data. Genome Research, 19, 136-142. http://genome.cshlp.org/content/19/1/136.

McLaren, C. G., L. Ramos, C. Lopez, and W. Eusebio. 2000. ``Applications of the geneaology manegment system.'' 
In \emph{International Crop Information System. Technical  Development Manual, version VI}, edited by McLaren, C. G., J.W. White 
and P.N. Fox. pp. 5.8-5.13. CIMMyT, Mexico: CIMMyT and IRRI. 

McLaren, C. G., R. Bruskiewich, A.M. Portugal, and A.B. Cosico. 2005. The International Rice Information System. 
A platform for meta-analysis of rice crop data. \emph{Plant Physiology} \bold{139}: 637-642.

}
\examples{

# example to optimize a training pop for a validation pop
data(DT_wheat)
DT <- as.data.frame(DT_wheat)
DT$id <- rownames(DT) # IDs
DT$occ <- 1; DT$occ[1]=0 # to track occurrences
DT$dummy <- 1; DT$dummy[1]=0 # dummy trait

# if genomic
GT <- GT_wheat + 1; rownames(GT) <- rownames(DT)
G <-  GT\%*\%t(GT)
G <- G/mean(diag(G))
# if pedigree
A <- A_wheat
A[1:4,1:4]
##Perform eigenvalue decomposition for clustering
##And select cluster 5 as target set to predict
pcNum=25
svdWheat <- svd(A, nu = pcNum, nv = pcNum)
PCWheat <- A \%*\% svdWheat$v
rownames(PCWheat) <- rownames(A)
DistWheat <- dist(PCWheat)
TreeWheat <- cutree(hclust(DistWheat), k = 5 )
plot(PCWheat[,1], PCWheat[,2], col = TreeWheat, 
     pch = as.character(TreeWheat), xlab = "pc1", ylab = "pc2")
vp <- rownames(PCWheat)[TreeWheat == 3]; length(vp)
tp <- setdiff(rownames(PCWheat),vp)

As <- A[tp,tp]
DT2 <- DT[rownames(As),]
DT2$cov <- apply(A[tp,vp],1,mean)

head(DT2)

\donttest{
# we assign a weight to x'Ax of (60*pi)/180=1
res<-evolafit(formula=cbind(cov, occ)~id, dt= DT2, 
              # constraints: if sum is greater than this ignore 
              constraintsUB = c(Inf, 100), 
              # constraints: if sum is smaller than this ignore
              constraintsLB= c(-Inf, -Inf), 
              # weight the traits for the selection
              traitWeight = c(1,0), 
              # population parameters
              nCrosses = 100, nProgeny = 10, 
              recombGens=1, nChr=1, mutRate=0,
              # coancestry parameters
              A=As, lambda= (60*pi)/180 , nQTLperInd = 80, 
              # selection parameters
              propSelBetween = 0.5, propSelWithin =0.5, 
              nGenerations = 30, verbose = TRUE, keepBest=FALSE) 


best <- bestSol(res)["pop","cov"]
sum(res$M[best,]) # total # of inds selected
pareto(res)
}

}
\keyword{datasets}
