% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitmgng.r
\name{fitmgng}
\alias{fitmgng}
\alias{litmgng}
\alias{nlitmgng}
\alias{profluitmgng}
\alias{nluitmgng}
\alias{litmgng}
\alias{fitmgng}
\alias{nlitmgng}
\alias{profluitmgng}
\alias{nluitmgng}
\alias{nlitmgng}
\alias{fitmgng}
\alias{litmgng}
\alias{profluitmgng}
\alias{nluitmgng}
\alias{profleuitmgng}
\alias{fitmgng}
\alias{litmgng}
\alias{nlitmgng}
\alias{profluitmgng}
\alias{nluitmgng}
\alias{nleuitmgng}
\alias{fitmgng}
\alias{litmgng}
\alias{nlitmgng}
\alias{profluitmgng}
\alias{nluitmgng}
\title{MLE Fitting of Normal Bulk and GPD for Both Tails Interval Transition Mixture Model}
\usage{
fitmgng(x, eseq = NULL, ulseq = NULL, urseq = NULL, fixedeu = FALSE,
  pvector = NULL, std.err = TRUE, method = "BFGS", control = list(maxit
  = 10000), finitelik = TRUE, ...)

litmgng(x, nmean = 0, nsd = 1, epsilon = nsd, ul = 0, sigmaul = 1,
  xil = 0, ur = 0, sigmaur = 1, xir = 0, log = TRUE)

nlitmgng(pvector, x, finitelik = FALSE)

profleuitmgng(eulr, pvector, x, method = "BFGS", control = list(maxit =
  10000), finitelik = TRUE, ...)

nleuitmgng(pvector, epsilon, ul, ur, x, finitelik = FALSE)
}
\arguments{
\item{x}{vector of sample data}

\item{eseq}{vector of epsilons (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{ulseq}{vector of lower thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{urseq}{vector of upper thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedeu}{logical, should threshold and epsilon be fixed
(at either scalar value in \code{useq} and \code{eseq},
or estimated from maximum of profile likelihood evaluated at
grid of thresholds and epsilons in \code{useq} and \code{eseq})}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{nmean}{scalar normal mean}

\item{nsd}{scalar normal standard deviation (positive)}

\item{epsilon}{interval half-width}

\item{ul}{lower tail threshold}

\item{sigmaul}{lower tail GPD scale parameter (positive)}

\item{xil}{lower tail GPD shape parameter}

\item{ur}{upper tail threshold}

\item{sigmaur}{upper tail GPD scale parameter (positive)}

\item{xir}{upper tail GPD shape parameter}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}

\item{eulr}{vector of epsilon, lower and upper thresholds considered in profile likelihood}
}
\value{
Log-likelihood is given by \code{\link[evmix:fitmgng]{litmgng}} and it's
  wrappers for negative log-likelihood from \code{\link[evmix:fitmgng]{nlitmgng}}
  and \code{\link[evmix:fitmgng]{nluitmgng}}. Profile likelihood for 
  thresholds and interval half-width given by \code{\link[evmix:fitmgng]{profluitmgng}}.
  Fitting function \code{\link[evmix:fitmgng]{fitmgng}} returns a simple list with the
  following elements

\tabular{ll}{
 \code{call}:      \tab \code{optim} call\cr
 \code{x}:         \tab data vector \code{x}\cr
 \code{init}:      \tab \code{pvector}\cr
 \code{fixedeu}:   \tab fixed epsilon and threshold, logical\cr
 \code{ulseq}:     \tab lower threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{urseq}:     \tab upper threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{eseq}:      \tab interval half-width vector for profile likelihood or scalar for fixed threshold\cr
 \code{nllheuseq}: \tab profile negative log-likelihood at each combination in (eseq, ulseq, urseq)\cr
 \code{optim}:     \tab complete \code{optim} output\cr
 \code{mle}:       \tab vector of MLE of parameters\cr
 \code{cov}:       \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:        \tab vector of standard errors of MLE of parameters\cr
 \code{nllh}:      \tab minimum negative log-likelihood\cr
 \code{n}:         \tab total sample size\cr
 \code{nmean}:     \tab MLE of normal mean\cr
 \code{nsd}:       \tab MLE of normal standard deviation\cr
 \code{epsilon}:   \tab MLE of transition half-width\cr
 \code{ul}:        \tab lower threshold (fixed or MLE)\cr
 \code{sigmaul}:   \tab MLE of lower tail GPD scale\cr
 \code{xil}:       \tab MLE of lower tail GPD shape\cr
 \code{ur}:        \tab upper threshold (fixed or MLE)\cr
 \code{sigmaur}:   \tab MLE of upper tail GPD scale\cr
 \code{xir}:       \tab MLE of upper tail GPD shape\cr
}
}
\description{
Maximum likelihood estimation for fitting the extreme value 
mixture model with normal for bulk distribution between thresholds, conditional
GPDs beyond thresholds and interval transition. With options for profile likelihood
estimation for both thresholds and interval half-width, which can also be fixed.
}
\details{
The extreme value mixture model with the normal bulk and GPD for both tails interval
transition is fitted to the entire dataset using maximum likelihood estimation. The estimated
parameters, variance-covariance matrix and their standard errors are automatically
output.

See \code{\link[evmix:itmgng]{ditmgng}} for explanation of GPD-normal-GPD interval
transition model, including mixing functions.

See also help for \code{\link[evmix:fnormgpd]{fnormgpd}} for details, type \code{help fnormgpd}. 
Only the different features are outlined below for brevity.

The full parameter vector is
(\code{nmean}, \code{nsd}, \code{epsilon}, \code{ul}, \code{sigmaul}, \code{xil},
                                           \code{ur}, \code{sigmaur}, \code{xir})
if thresholds and interval half-width are also estimated and
(\code{nmean}, \code{nsd}, \code{sigmaul}, \code{xil}, \code{sigmaur}, \code{xir})
for profile likelihood or fixed threshold approach.

If the profile likelihood approach is used, then a grid search over all combinations of epsilons and both thresholds
are carried out. The combinations which lead to less than 5 in any component outside of the
intervals are not considered.

A fixed pair of thresholds and epsilon approach is acheived by setting a single
scalar value to each in \code{ulseq}, \code{urseq} and \code{eseq} respectively.
}
\note{
When \code{pvector=NULL} then the initial values are:
\itemize{
 \item MLE of normal parameters assuming entire population is normal; and
 \item lower threshold 10\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item upper threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of GPD parameters beyond threshold. 
}
}
\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}. Based on code
by Xin Zhao produced for MATLAB.
}

\examples{
\dontrun{
set.seed(1)
par(mfrow = c(1, 1))

x = rnorm(1000)
xx = seq(-4, 4, 0.01)
y = dnorm(xx)

# MLE for complete parameter set (not recommended!)
fit = fitmgng(x)
hist(x, breaks = seq(-6, 6, 0.1), freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, ditmgng(xx, nmean, nsd, epsilon, ul, sigmaul, xil,
                                                     ur, sigmaur, xir), col="red"))
abline(v = fit$ul + fit$epsilon * seq(-1, 1), col = "red")
abline(v = fit$ur + fit$epsilon * seq(-1, 1), col = "darkred")
  
# Profile likelihood for threshold which is then fixed
fitfix = fitmgng(x, eseq = seq(0, 2, 0.1), ulseq = seq(-2.5, 0, 0.25), 
                                         urseq = seq(0, 2.5, 0.25), fixedeu = TRUE)
with(fitfix, lines(xx, ditmgng(xx, nmean, nsd, epsilon, ul, sigmaul, xil,
                                                      ur, sigmaur, xir), col="blue"))
abline(v = fitfix$ul + fitfix$epsilon * seq(-1, 1), col = "blue")
abline(v = fitfix$ur + fitfix$epsilon * seq(-1, 1), col = "darkblue")
legend("topright", c("True Density", "GPD-normal-GPD ITM", "Profile likelihood"),
  col=c("black", "red", "blue"), lty = 1)
}
  
}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/Normal_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Holden, L. and Haug, O. (2013). A mixture model for unsupervised tail
estimation. arxiv:0902.4137
}
\seealso{
\code{\link[evmix:fgng]{fgng}}, \code{\link[stats:Normal]{dnorm}},
 \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}

Other normgpd normgpdcon gng gngcon fnormgpd fnormgpdcon fgng fgngcon: \code{\link{fgngcon}},
  \code{\link{fgng}}, \code{\link{fnormgpdcon}},
  \code{\link{fnormgpd}}, \code{\link{gngcon}},
  \code{\link{gng}}, \code{\link{itmgng}},
  \code{\link{normgpdcon}}, \code{\link{normgpd}}
}
\author{
Alfadino Akbar and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
