% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ditmgng.r
\name{itmgng}
\alias{ditmgng}
\alias{itmgng}
\alias{pitmgng}
\alias{qitmgng}
\alias{ritmgng}
\title{Normal Bulk with GPD Upper and Lower Tails Interval Transition Mixture Model}
\usage{
ditmgng(x, nmean = 0, nsd = 1, epsilon = nsd, ul = qnorm(0.1, nmean,
  nsd), sigmaul = nsd, xil = 0, ur = qnorm(0.9, nmean, nsd),
  sigmaur = nsd, xir = 0, log = FALSE)

pitmgng(q, nmean = 0, nsd = 1, epsilon = nsd, ul = qnorm(0.1, nmean,
  nsd), sigmaul = nsd, xil = 0, ur = qnorm(0.9, nmean, nsd),
  sigmaur = nsd, xir = 0, lower.tail = TRUE)

qitmgng(p, nmean = 0, nsd = 1, epsilon, ul = qnorm(0.1, nmean, nsd),
  sigmaul = nsd, xil = 0, ur = qnorm(0.9, nmean, nsd), sigmaur = nsd,
  xir = 0, lower.tail = TRUE)

ritmgng(n = 1, nmean = 0, nsd = 1, epsilon = sd, ul = qnorm(0.1,
  nmean, nsd), sigmaul = nsd, xil = 0, ur = qnorm(0.9, nmean, nsd),
  sigmaur = nsd, xir = 0)
}
\arguments{
\item{x}{quantiles}

\item{nmean}{normal mean}

\item{nsd}{normal standard deviation (positive)}

\item{epsilon}{interval half-width}

\item{ul}{lower tail threshold}

\item{sigmaul}{lower tail GPD scale parameter (positive)}

\item{xil}{lower tail GPD shape parameter}

\item{ur}{upper tail threshold}

\item{sigmaur}{upper tail GPD scale parameter (positive)}

\item{xir}{upper tail GPD shape parameter}

\item{log}{logical, if TRUE then log density}

\item{q}{quantiles}

\item{lower.tail}{logical, if FALSE then upper tail probabilities}

\item{p}{cumulative probabilities}

\item{n}{sample size (positive integer)}
}
\value{
\code{\link[evmix:itmgng]{ditmgng}} gives the density,
\code{\link[evmix:itmgng]{pitmgng}} gives the cumulative distribution function,
\code{\link[evmix:itmgng]{qitmgng}} gives the quantile function and
\code{\link[evmix:itmgng]{ritmgng}} gives a random sample.
}
\description{
Density, cumulative distribution function, quantile function and
  random number generation for the extreme value mixture model with normal
  for bulk distribution between the upper and lower thresholds with
  conditional GPD's for the two tails and interval transition. The parameters are the normal mean
  \code{nmean} and standard deviation \code{nsd}, interval half-width \code{espilon},
  lower tail (threshold \code{ul}, GPD scale \code{sigmaul} and shape \code{xil} and
  tail fraction \code{phiul}) and upper tail (threshold \code{ur}, GPD scale
  \code{sigmaur} and shape \code{xiR} and tail fraction \code{phiuR}).
}
\details{
The interval transition extreme value mixture model combines a normal
distribution for the bulk between the lower and upper thresholds and GPD for
upper and lower tails, with a smooth transition over the interval
\eqn{(u-epsilon, u+epsilon)} (where \eqn{u} can be exchanged for the lower and
upper thresholds). The mixing function warps the normal to map from
\eqn{(u-epsilon, u)} to \eqn{(u-epsilon, u+epsilon)} and warps the GPD from
\eqn{(u, u+epsilon)} to \eqn{(u-epsilon, u+epsilon)}.

  The cumulative distribution function is defined by
  \deqn{F(x)=\kappa(G_l(q(x)) + H_t(r(x)) + G_u(p(x)))}
  where \eqn{H_t(x)} is the truncated normal cdf, i.e. \code{pnorm(x, nmean, nsd)}.
  The conditional GPD for the upper tail has cdf \eqn{G_u(x)},
  i.e. \code{pgpd(x, ur, sigmaur, xir)} and lower tail cdf \eqn{G_l(x)} is for the
  negated support, i.e. \code{1 - pgpd(-x, -ul, sigmaul, xil)}. The truncated
  normal is not renormalised to be proper, so \eqn{H_t(x)} contributes
  \code{pnorm(ur, nmean, nsd) - pnorm(ul, nmean, nsd)} to the cdf
  for all \eqn{x\geq (u_r + \epsilon)} and zero below \eqn{x\leq (u_l - \epsilon)}.
  The normalisation constant \eqn{\kappa} ensures a proper density, given by
   \code{1/(2 + pnorm(ur, nmean, nsd) - pnorm(ul, nmean, nsd)} where the
   2 is from two GPD components and latter is contribution from normal component.

  The mixing functions \eqn{q(x)}, \eqn{r(x)} and \eqn{p(x)} are reformulated from the
  \eqn{q_i(x)} suggested by Holden and Haug (2013). These are symmetric about each
  threshold, which for convenience will be referred to a simply \eqn{u}. So for
  computational convenience only a single \eqn{q(x;u)} has been implemented for the
  lower and upper GPD components called
  \code{\link[evmix:internal]{qmix}} for a given \eqn{u}, with the complementary
  mixing function then defined as \eqn{p(x;u)=-q(-x;-u)}. The bulk model mixing
  function \eqn{r(x)} utilises the equivalent of the \eqn{q(x)} for the lower threshold and
  \eqn{p(x)} for the upper threshold, so these are reused in the bulk mixing function
  \code{\link[evmix:internal]{qgbgmix}}.

  A minor adaptation of the mixing function has been applied following a similar
  approach to that explained in \code{\link[evmix:itmnormgpd]{ditmnormgpd}}. For the
  bulk model mixing function \eqn{r(x)}, we need \eqn{r(x)<=ul} for all \eqn{x\le ul - epsilon} and
  \eqn{r(x)>=ur} for all \eqn{x\ge ur+epsilon}, as then the bulk model will contribute
  zero below the lower interval and the constant \eqn{H_t(ur)=H(ur)-H(ul)} for all
  \eqn{x} above the upper interval. Holden and Haug (2013) define
  \eqn{r(x)=x-\epsilon} for all \eqn{x\ge ur} and \eqn{r(x)=x+\epsilon} for all \eqn{x\le ul}.
  For more straightforward and interpretable
  computational implementation the mixing function has been set to the lower threshold
  \eqn{r(x)=u_l} for all \eqn{x\le u_l-\epsilon} and to the upper threshold
  \eqn{r(x)=u_r} for all \eqn{x\le u_r+\epsilon}, so the cdf/pdf of the normal model can be used
  directly. We do not have to define cdf/pdf for the non-proper truncated normal
  seperately. As such \eqn{r'(x)=0} for all \eqn{x\le u_l-\epsilon} and \eqn{x\ge u_r+\epsilon} in
  \code{\link[evmix:internal]{qmixxprime}}, which also makes it clearer that
  normal does not contribute to either tails beyond the intervals and vice-versa.

  The quantile function within the transition interval is not available in
  closed form, so has to be solved numerically. Outside of the
  interval, the quantile are obtained from the normal and GPD components directly.
}
\note{
All inputs are vectorised except \code{log} and \code{lower.tail}.
The main input (\code{x}, \code{p} or \code{q}) and parameters must be either
a scalar or a vector. If vectors are provided they must all be of the same length,
and the function will be evaluated for each element of vector. In the case of
\code{\link[evmix:itmgng]{ritmgng}} any input vector must be of length \code{n}.

Default values are provided for all inputs, except for the fundamentals
\code{x}, \code{q} and \code{p}. The default sample size for
\code{\link[evmix:itmgng]{ritmgng}} is 1.

Missing (\code{NA}) and Not-a-Number (\code{NaN}) values in \code{x},
\code{p} and \code{q} are passed through as is and infinite values are set to
\code{NA}. None of these are not permitted for the parameters.

Error checking of the inputs (e.g. invalid probabilities) is carried out and
will either stop or give warning message as appropriate.
}
\examples{
\dontrun{
set.seed(1)
par(mfrow = c(2, 2))

xx = seq(-5, 5, 0.01)
ul = -1.5;ur = 2
epsilon = 0.8
kappa = 1/(2 + pnorm(ur, 0, 1) - pnorm(ul, 0, 1))

f = ditmgng(xx, nmean = 0, nsd = 1, epsilon, ul, sigmaul = 1, xil = 0.5, ur, sigmaur = 1, xir = 0.5)
plot(xx, f, ylim = c(0, 0.5), xlim = c(-5, 5), type = 'l', lwd = 2, xlab = "x", ylab = "density")
lines(xx, kappa * dgpd(-xx, -ul, sigmau = 1, xi = 0.5), col = "blue", lty = 2, lwd = 2)
lines(xx, kappa * dnorm(xx, 0, 1), col = "red", lty = 2, lwd = 2)
lines(xx, kappa * dgpd(xx, ur, sigmau = 1, xi = 0.5), col = "green", lty = 2, lwd = 2)
abline(v = ul + epsilon * seq(-1, 1), lty = c(2, 1, 2), col = "blue")
abline(v = ur + epsilon * seq(-1, 1), lty = c(2, 1, 2), col = "green")
legend('topright', c('Normal-GPD ITM', 'kappa*GPD Lower', 'kappa*Normal', 'kappa*GPD Upper'),
      col = c("black", "blue", "red", "green"), lty = c(1, 2, 2, 2), lwd = 2)

# cdf contributions
F = pitmgng(xx, nmean = 0, nsd = 1, epsilon, ul, sigmaul = 1, xil = 0.5, ur, sigmaur = 1, xir = 0.5)
plot(xx, F, ylim = c(0, 1), xlim = c(-5, 5), type = 'l', lwd = 2, xlab = "x", ylab = "cdf")
lines(xx[xx < ul], kappa * (1 - pgpd(-xx[xx < ul], -ul, 1, 0.5)), col = "blue", lty = 2, lwd = 2)
lines(xx[(xx >= ul) & (xx <= ur)], kappa * (1 + pnorm(xx[(xx >= ul) & (xx <= ur)], 0, 1) -
      pnorm(ul, 0, 1)), col = "red", lty = 2, lwd = 2)
lines(xx[xx > ur], kappa * (1 + (pnorm(ur, 0, 1) - pnorm(ul, 0, 1)) +
      pgpd(xx[xx > ur], ur, sigmau = 1, xi = 0.5)), col = "green", lty = 2, lwd = 2)
abline(v = ul + epsilon * seq(-1, 1), lty = c(2, 1, 2), col = "blue")
abline(v = ur + epsilon * seq(-1, 1), lty = c(2, 1, 2), col = "green")
legend('topleft', c('Normal-GPD ITM', 'kappa*GPD Lower', 'kappa*Normal', 'kappa*GPD Upper'),
      col = c("black", "blue", "red", "green"), lty = c(1, 2, 2, 2), lwd = 2)

# simulated data density histogram and overlay true density
x = ritmgng(10000, nmean = 0, nsd = 1, epsilon, ul, sigmaul = 1, xil = 0.5,
                                                ur, sigmaur = 1, xir = 0.5)
hist(x, freq = FALSE, breaks = seq(-1000, 1000, 0.1), xlim = c(-5, 5))
lines(xx, ditmgng(xx, nmean = 0, nsd = 1, epsilon, ul, sigmaul = 1, xil = 0.5,
  ur, sigmaur = 1, xir = 0.5), lwd = 2, col = 'black')
}
}
\author{
Alfadino Akbar and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
\references{
\url{http://en.wikipedia.org/wiki/Normal_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Holden, L. and Haug, O. (2013). A mixture model for unsupervised tail
estimation. arxiv:0902.4137
}
\seealso{
\code{\link[evmix:gng]{gng}}, \code{\link[evmix:normgpd]{normgpd}},
           \code{\link[evmix:gpd]{gpd}} and \code{\link[stats:Normal]{dnorm}}

Other normgpd normgpdcon gng gngcon fnormgpd fnormgpdcon fgng fgngcon: \code{\link{dgngcon}},
  \code{\link{dgngcon}}, \code{\link{dgngcon}},
  \code{\link{dgngcon}}, \code{\link{dgngcon}},
  \code{\link{gngcon}}, \code{\link{gngcon}},
  \code{\link{gngcon}}, \code{\link{gngcon}},
  \code{\link{gngcon}}, \code{\link{pgngcon}},
  \code{\link{pgngcon}}, \code{\link{pgngcon}},
  \code{\link{pgngcon}}, \code{\link{pgngcon}},
  \code{\link{qgngcon}}, \code{\link{qgngcon}},
  \code{\link{qgngcon}}, \code{\link{qgngcon}},
  \code{\link{qgngcon}}, \code{\link{rgngcon}},
  \code{\link{rgngcon}}, \code{\link{rgngcon}},
  \code{\link{rgngcon}}, \code{\link{rgngcon}};
  \code{\link{dgng}}, \code{\link{dgng}},
  \code{\link{dgng}}, \code{\link{dgng}},
  \code{\link{dgng}}, \code{\link{gng}}, \code{\link{gng}},
  \code{\link{gng}}, \code{\link{gng}}, \code{\link{gng}},
  \code{\link{pgng}}, \code{\link{pgng}},
  \code{\link{pgng}}, \code{\link{pgng}},
  \code{\link{pgng}}, \code{\link{qgng}},
  \code{\link{qgng}}, \code{\link{qgng}},
  \code{\link{qgng}}, \code{\link{qgng}},
  \code{\link{rgng}}, \code{\link{rgng}},
  \code{\link{rgng}}, \code{\link{rgng}},
  \code{\link{rgng}}; \code{\link{dnormgpdcon}},
  \code{\link{dnormgpdcon}}, \code{\link{dnormgpdcon}},
  \code{\link{dnormgpdcon}}, \code{\link{dnormgpdcon}},
  \code{\link{normgpdcon}}, \code{\link{normgpdcon}},
  \code{\link{normgpdcon}}, \code{\link{normgpdcon}},
  \code{\link{normgpdcon}}, \code{\link{pnormgpdcon}},
  \code{\link{pnormgpdcon}}, \code{\link{pnormgpdcon}},
  \code{\link{pnormgpdcon}}, \code{\link{pnormgpdcon}},
  \code{\link{qnormgpdcon}}, \code{\link{qnormgpdcon}},
  \code{\link{qnormgpdcon}}, \code{\link{qnormgpdcon}},
  \code{\link{qnormgpdcon}}, \code{\link{rnormgpdcon}},
  \code{\link{rnormgpdcon}}, \code{\link{rnormgpdcon}},
  \code{\link{rnormgpdcon}}, \code{\link{rnormgpdcon}};
  \code{\link{dnormgpd}}, \code{\link{dnormgpd}},
  \code{\link{dnormgpd}}, \code{\link{dnormgpd}},
  \code{\link{dnormgpd}}, \code{\link{normgpd}},
  \code{\link{normgpd}}, \code{\link{normgpd}},
  \code{\link{normgpd}}, \code{\link{normgpd}},
  \code{\link{pnormgpd}}, \code{\link{pnormgpd}},
  \code{\link{pnormgpd}}, \code{\link{pnormgpd}},
  \code{\link{pnormgpd}}, \code{\link{qnormgpd}},
  \code{\link{qnormgpd}}, \code{\link{qnormgpd}},
  \code{\link{qnormgpd}}, \code{\link{qnormgpd}},
  \code{\link{rnormgpd}}, \code{\link{rnormgpd}},
  \code{\link{rnormgpd}}, \code{\link{rnormgpd}},
  \code{\link{rnormgpd}}; \code{\link{fgngcon}},
  \code{\link{fgngcon}}, \code{\link{fgngcon}},
  \code{\link{fgngcon}}, \code{\link{fgngcon}},
  \code{\link{lgngcon}}, \code{\link{lgngcon}},
  \code{\link{lgngcon}}, \code{\link{lgngcon}},
  \code{\link{lgngcon}}, \code{\link{nlgngcon}},
  \code{\link{nlgngcon}}, \code{\link{nlgngcon}},
  \code{\link{nlgngcon}}, \code{\link{nlgngcon}},
  \code{\link{nlugngcon}}, \code{\link{nlugngcon}},
  \code{\link{nlugngcon}}, \code{\link{nlugngcon}},
  \code{\link{nlugngcon}}, \code{\link{proflugngcon}},
  \code{\link{proflugngcon}}, \code{\link{proflugngcon}},
  \code{\link{proflugngcon}}, \code{\link{proflugngcon}};
  \code{\link{fgng}}, \code{\link{fgng}},
  \code{\link{fgng}}, \code{\link{fgng}},
  \code{\link{fgng}}, \code{\link{lgng}},
  \code{\link{lgng}}, \code{\link{lgng}},
  \code{\link{lgng}}, \code{\link{lgng}},
  \code{\link{nlgng}}, \code{\link{nlgng}},
  \code{\link{nlgng}}, \code{\link{nlgng}},
  \code{\link{nlgng}}, \code{\link{nlugng}},
  \code{\link{nlugng}}, \code{\link{nlugng}},
  \code{\link{nlugng}}, \code{\link{nlugng}},
  \code{\link{proflugng}}, \code{\link{proflugng}},
  \code{\link{proflugng}}, \code{\link{proflugng}},
  \code{\link{proflugng}}; \code{\link{fitmgng}},
  \code{\link{fitmgng}}, \code{\link{fitmgng}},
  \code{\link{fitmgng}}, \code{\link{fitmgng}},
  \code{\link{litmgng}}, \code{\link{litmgng}},
  \code{\link{litmgng}}, \code{\link{litmgng}},
  \code{\link{litmgng}}, \code{\link{nleuitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nlitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nlitmgng}},
  \code{\link{nlitmgng}}, \code{\link{nluitmgng}},
  \code{\link{nluitmgng}}, \code{\link{nluitmgng}},
  \code{\link{nluitmgng}}, \code{\link{nluitmgng}},
  \code{\link{profleuitmgng}}, \code{\link{profluitmgng}},
  \code{\link{profluitmgng}}, \code{\link{profluitmgng}},
  \code{\link{profluitmgng}}, \code{\link{profluitmgng}};
  \code{\link{fnormgpdcon}}, \code{\link{fnormgpdcon}},
  \code{\link{fnormgpdcon}}, \code{\link{fnormgpdcon}},
  \code{\link{fnormgpdcon}}, \code{\link{lnormgpdcon}},
  \code{\link{lnormgpdcon}}, \code{\link{lnormgpdcon}},
  \code{\link{lnormgpdcon}}, \code{\link{lnormgpdcon}},
  \code{\link{nlnormgpdcon}}, \code{\link{nlnormgpdcon}},
  \code{\link{nlnormgpdcon}}, \code{\link{nlnormgpdcon}},
  \code{\link{nlnormgpdcon}}, \code{\link{nlunormgpdcon}},
  \code{\link{nlunormgpdcon}}, \code{\link{nlunormgpdcon}},
  \code{\link{nlunormgpdcon}}, \code{\link{nlunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}},
  \code{\link{proflunormgpdcon}}; \code{\link{fnormgpd}},
  \code{\link{fnormgpd}}, \code{\link{fnormgpd}},
  \code{\link{fnormgpd}}, \code{\link{fnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{lnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{lnormgpd}},
  \code{\link{lnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlnormgpd}}, \code{\link{nlnormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{nlunormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{nlunormgpd}},
  \code{\link{nlunormgpd}}, \code{\link{proflunormgpd}},
  \code{\link{proflunormgpd}}, \code{\link{proflunormgpd}},
  \code{\link{proflunormgpd}}, \code{\link{proflunormgpd}}
}

