% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_extractor.R
\name{coefficient_extractor.evinb}
\alias{coefficient_extractor.evinb}
\title{Bootstrap coefficient extractor}
\usage{
\method{coefficient_extractor}{evinb}(
  object,
  component = c("nb", "evinf", "pareto", "all"),
  ...
)
}
\arguments{
\item{object}{A fitted evinb model with bootstraps}

\item{component}{Which component should be extracted}

\item{...}{Not in use}
}
\value{
A tibble with coefficient values, one row per bootstrap and component
}
\description{
Bootstrap coefficient extractor
}
\examples{
data(genevzinb2)
model <- evinb(y~x1+x2+x3,data=genevzinb2, n_bootstraps = 10, multicore = TRUE, ncores = 2)
coefficient_extractor(model, component = 'all')

}
