% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers_list.R
\name{handlers_list}
\alias{handlers_list}
\alias{validate_handlers_list}
\alias{new_handlers_list}
\title{Handler List Constructor}
\usage{
handlers_list(...)

validate_handlers_list(...)

new_handlers_list(...)
}
\arguments{
\item{...}{A set of handler objects.}
}
\value{
The \code{handlers_list()} function returns a list of \code{handlers} objects.
}
\description{
A handler list constructor. The function validates the structure of
the input params and creates a handlers_list object.
}
\examples{

measurement_handler <- handler(
  type = 'MEASUREMENT',
  FUN = function(obj, event) {
    obj$measurement = get_attr(event, 'measurement')
   return(obj)
  }
)

bmi_handler <- handler(
  type = 'BMI',
  FUN  = function(obj, event) {

   obj$imc <- get_attr(event, 'mass') / get_attr(event, 'height')^2
   return(obj)

  }
)

handlers <- handlers_list(measurement_handler, bmi_handler)

}
