% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBFinit.R
\name{RBFinit}
\alias{RBFinit}
\title{Initialization of parameters for a Radial Basis Function classifier}
\usage{
RBFinit(x, y, nproto)
}
\arguments{
\item{x}{Input matrix of size n x d, where n is the number of objects and d the number of
attributes.}

\item{y}{Vector of class labels (of length n). May be a factor, or a vector of
integers from 1 to M (number of classes).}

\item{nproto}{Number of prototypes}
}
\value{
A list with three elements containing the initialized network parameters
  \describe{
  \item{P}{Matrix of size (R,d), containing the R prototype coordinates.}
  \item{Gamma}{Vector of length R, containing the scale parameters.}
  \item{W}{Matrix of size (R,M), containing the hidden-to-output weights.}
 }
}
\description{
\code{RBFinit} returns initial parameter values for a Radial Basis Function classifier.
}
\details{
The prototypes are initialized by the k-means algorithms. The hidden-to-output weights are initialized
by linear regression. The scale parameter for each prototype is computed as the inverse of the square
root of the mean squared distances to this prototype. The final number of prototypes may be different
from the desired number \code{nproto} depending on the result of the k-means clustering (clusters
composed of only one input vector are discarded).
}
\examples{
## Glass dataset
data(glass)
xapp<-glass$x[1:89,]
yapp<-glass$y[1:89]
param0<-RBFinit(xapp,yapp,nproto=7)
param0
}
\seealso{
\code{\link{RBFfit}}, \code{\link{RBFval}}
}
\author{
Thierry Denoeux.
}
