% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_latent_trawl.R
\name{rtrawl}
\alias{rtrawl}
\title{Simulation of trawl process path using Slice partition. If using customised
trawl functions and primitives (i.e. \code{trawl.function = NA}), then, it is
required that the user provides \code{length(times) + deep_cols} such
functions and primitives where the \code{deep_cols} first one are used to
reconstuct the first trawl value.}
\usage{
rtrawl(alpha, beta, times, marg.dist, trawl.function = NA,
  trawl.fs = NA, trawl.fs.prim = NA, n, rho = NA, kappa = 0,
  transformation = F, offset_shape = NULL, offset_scale = NULL,
  deep_cols = 30)
}
\arguments{
\item{alpha}{Shape parameter.}

\item{beta}{Scale parameter.}

\item{times}{Vectors of discret times.}

\item{marg.dist}{Name of infinitely divisible distribution. Currenlty
implemented: gamma, gaussian, generalised hyperbolic, generalised inverse
gaussian.}

\item{trawl.function}{Type of trawl function that should be used. Default NA.}

\item{trawl.fs}{collection of trawl functions indexed on \code{times}.
Default NA. Default NA if no \code{trawl.function} is indicated and should
contain as many as in \code{times}.}

\item{trawl.fs.prim}{collection of trawl functions primitives indexed on
\code{times}. Default NA if no \code{trawl.function} is indicated and
should contain as many as in \code{times}.}

\item{n}{Number of simulations (so far, only \code{n=1} is implemented).}

\item{rho}{Trawl parameters. Must be positive if Exponential trawls are used.}

\item{kappa}{Additive constant to scale parameter \code{beta}.}

\item{transformation}{Boolean to apply marginal transform method. Default is
False (F).}

\item{offset_shape}{Transformed-marginal Shape parameter.}

\item{offset_scale}{Transformed-marginal Scale parameter.}

\item{deep_cols}{Depth of reconstruction (columns). Default is 30.}
}
\value{
Simulated path (size the same as times) of trawl process.
}
\description{
Simulation of trawl process path using Slice partition. If using customised
trawl functions and primitives (i.e. \code{trawl.function = NA}), then, it is
required that the user provides \code{length(times) + deep_cols} such
functions and primitives where the \code{deep_cols} first one are used to
reconstuct the first trawl value.
}
\examples{
alpha <- 5
beta <- 3
times <- 1:150
rho <- 0.2
trawl.function <- "exp"
margi <- "gamma"
kappa <- 0
n <- 1
rtrawl(alpha = alpha, beta = beta, kappa = kappa, times = times, n = 1,
marg.dist = margi, rho = rho, trawl.function = trawl.function)

}
