% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_eurostat.R
\name{search_eurostat}
\alias{search_eurostat}
\alias{grepEurostatTOC}
\title{Grep Datasets Titles from Eurostat}
\usage{
search_eurostat(pattern, type = "dataset", fixed = TRUE)

grepEurostatTOC(pattern, type = "dataset")
}
\arguments{
\item{pattern}{Character, datasets, folder or tables with this pattern in
the description will be returned (depending on the 'type' argument)}

\item{type}{Grep the Eurostat table of contents either for
'dataset' (default), 'folder', 'table' or "all" (for all types).}

\item{fixed}{logical. If TRUE, pattern is a string to be matched as is.
Change to FALSE if more complex regex matching is needed.}
}
\value{
A tibble with eight columns
\itemize{
\item \strong{title}: The name of dataset of theme
\itemize{
\item \strong{code}: The codename of dataset of theme, will be used by the
\code{\link[=get_eurostat]{get_eurostat()}} and \code{\link[=get_eurostat_raw]{get_eurostat_raw()}} functions.
\item \strong{type}: Is it a dataset, folder or table.
\item \strong{last.update.of.data, last.table.structure.change, data.start,
data.end}: Dates.
}
}
}
\description{
Lists names of dataset from eurostat with the particular
pattern in the description.
}
\details{
Downloads list of all datasets available on
eurostat and return list of names of datasets that contains particular
pattern in the dataset description. E.g. all datasets related to
education of teaching.
}
\section{Functions}{
\itemize{
\item \code{grepEurostatTOC}: Old deprecated version
}}

\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
tmp <- search_eurostat("education")
head(tmp)
# Use "fixed = TRUE" when pattern has characters that would need escaping.
# Here, parentheses would normally need to be escaped in regex
tmp <- search_eurostat("Live births (total) by NUTS 3 region", fixed = TRUE)
}
\dontshow{\}) # examplesIf}
}
\references{
See \code{citation("eurostat")}:\preformatted{# 
# Kindly cite the eurostat R package as follows:
# 
#   (C) Leo Lahti, Janne Huovari, Markus Kainu, Przemyslaw Biecek.
#   Retrieval and analysis of Eurostat open data with the eurostat
#   package. R Journal 9(1):385-392, 2017. doi: 10.32614/RJ-2017-019
#   Package URL: http://ropengov.github.io/eurostat Article URL:
#   https://journal.r-project.org/archive/2017/RJ-2017-019/index.html
# 
# A BibTeX entry for LaTeX users is
# 
#   @Article\{,
#     title = \{Retrieval and Analysis of Eurostat Open Data with the eurostat Package\},
#     author = \{Leo Lahti and Janne Huovari and Markus Kainu and Przemyslaw Biecek\},
#     journal = \{The R Journal\},
#     volume = \{9\},
#     number = \{1\},
#     pages = \{385--392\},
#     year = \{2017\},
#     doi = \{10.32614/RJ-2017-019\},
#     url = \{https://doi.org/10.32614/RJ-2017-019\},
#   \}
}
}
\seealso{
\code{\link[=get_eurostat]{get_eurostat()}}, \code{\link[=get_eurostat_toc]{get_eurostat_toc()}}
}
\author{
Przemyslaw Biecek and Leo Lahti \href{mailto:ropengov-forum@googlegroups.com}{ropengov-forum@googlegroups.com}
}
\keyword{database}
\keyword{utilities}
