% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get_eurostat_dic.R
\name{get_eurostat_dic}
\alias{getEurostatDictionary}
\alias{get_eurostat_dic}
\title{Download a Eurostat dictionary}
\usage{
get_eurostat_dic(dictname)

getEurostatDictionary(dictname)
}
\arguments{
\item{dictname}{Character, dictionary for given variable name
        will be downloaded.

Returns:}
}
\value{
A data.frame with two columns, first with code names and
         second with full names.
}
\description{
Download a dictionary for given coded variable from
             Eurostat (ec.europa.eu/eurostat). Dictionaries link
             codes with human-readable labels. To translate codes to labels
             with \code{\link{label_eurostat}}.

Arguments:
}
\section{Functions}{
\itemize{
\item \code{getEurostatDictionary}: Old deprecated version
}}
\examples{
\dontrun{
	       tmp <- get_eurostat_dic("crop_pro")
	       head(tmp)
	     }
}
\author{
Przemyslaw Biecek and Leo Lahti \email{ropengov-forum@googlegroups.com}
}
\references{
see citation("eurostat").
}
\seealso{
\code{\link{label_eurostat}}, \code{\link{get_eurostat}}, \code{\link{search_eurostat}}.
}
\keyword{database}
\keyword{utilities}

