% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eurotime2date.R
\name{eurotime2date}
\alias{eurotime2date}
\title{Date conversion from Eurostat time format}
\usage{
eurotime2date(x, last = FALSE)
}
\arguments{
\item{x}{a charter string with time information in Eurostat time format.}

\item{last}{a logical. If \code{FALsE} (default) the date  is
the first date of the period (month, quarter or year). If \code{TRUE} the date is the last date of
the period.}
}
\value{
an object of class \code{\link{Date}}.
}
\description{
A function to convert Eurostat time values to objects of class \code{\link{Date}} representing calendar dates.
}
\examples{
\dontrun{
   lp <- get_eurostat("namq_aux_lp", time_format = "raw")
   lp$time <- eurotime2date(x = lp$time)

   un <- get_eurostat("une_rt_m", time_format = "raw")
   un$time <- eurotime2date(x = un$time)

   lpa <- get_eurostat("nama_aux_lp", time_format = "raw")
   lpa$time <- eurotime2date(x = lpa$time)
   }
}
\author{
Janne Huovari \email{ropengov-forum@googlegroups.com} \url{http://github.com/ropengov/eurostat}
}

