% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_lablinks_count.r
\name{epmc_lablinks_count}
\alias{epmc_lablinks_count}
\title{Summarise links to external sources}
\usage{
epmc_lablinks_count(ext_id = NULL, data_src = "med")
}
\arguments{
\item{ext_id}{publication identifier}

\item{data_src}{data source, by default Pubmed/MedLine index will be searched.
The following three letter codes represents the sources
Europe PubMed Central supports:
\describe{
  \item{agr}{Agricola is a bibliographic database of citations to the
  agricultural literature created by the US National Agricultural Library
  and its co-operators.}
  \item{cba}{Chinese Biological Abstracts}
  \item{ctx}{CiteXplore}
  \item{eth}{EthOs Theses, i.e. PhD theses (British Library)}
  \item{hir}{NHS Evidence}
  \item{med}{PubMed/Medline NLM}
  \item{nbk}{Europe PMC Book metadata}
  \item{pat}{Biological Patents}
  \item{pmc}{PubMed Central}
  }}
}
\value{
data.frame with counts for each database
}
\description{
With the External Link services, Europe PMC allows third parties to publish
links from Europe PMC to other webpages or tools. Current External Link
providers, which can be selected through Europe PMC's advanced search,
include Wikipedia, Dryad Digital Repository or the institutional repo of
Bielefeld University. For more information, see
\url{https://europepmc.org/labslink}.
}
\examples{
   \dontrun{
   epmc_lablinks_count("24023770")
   epmc_lablinks_count("PMC3986813", data_src = "pmc")
   }
}
