% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orders.R
\name{etrd_transaction_detail}
\alias{etrd_transaction_detail}
\title{ETrade Transaction Details}
\usage{
etrd_transaction_detail(
  account,
  transactionId,
  output = c("df", "list"),
  access_tokens = NULL,
  etrade_cred = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{account}{The account ID key, not the account ID associated with the
specific account. Use \code{\link{etrd_account_list}} to identify the
proper account id key.}

\item{transactionId}{A transaction id that comes from
\code{\link{etrd_transactions}}}

\item{output}{Indicate whether the output should be in the form of a data
frame ('df') or list ('list'). Data frame is returned by default.}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
a list or data frame of transaction details
}
\description{
Get transaction details for the specified transaction
}
\examples{
\dontrun{

# Search for mutual fund buys over the last month
account_id = etrd_account_list()$accountIdKey[1]
transID = etrd_transactions(account_id)$transactionId[1]
etrd_transaction_detail(account_id, transID)

}
}
