% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVe.R
\name{CVe}
\alias{CVe}
\title{Cultural Value of ethnospecies (CVe)}
\source{
Reyes-Garcia, V., T. Huanca, V. Vadez, and W. Leonard. “Cultural, Practical, and Economic Value of Wild Plants: A Quantitative Study in the Bolivian Amazon.” Economic Botany, 2006. <https://doi.org/10.2307/4257061>
}
\usage{
CVe(data)
}
\arguments{
\item{data}{is an ethnobotany data set with column 1 'informant' and 2 'sp_name' as row identifiers of informants and of species names respectively.}
}
\description{
Calculates the Cultural Value (CVe) per ethnospecies.
}
\examples{

#Use built-in ethnobotany data example
CVe(ethnobotanydata)

#Generate random dataset of three informants uses for four species
eb_data <- data.frame(replicate(10,sample(0:1,20,rep=TRUE)))
names(eb_data) <- gsub(x = names(eb_data), pattern = "X", replacement = "Use_")  
eb_data$informant<-sample(c('User_1', 'User_2', 'User_3'), 20, replace=TRUE)
eb_data$sp_name<-sample(c('sp_1', 'sp_2', 'sp_3', 'sp_4'), 20, replace=TRUE)
CVe(eb_data)

}
\keyword{cultural}
\keyword{ethnobotany}
\keyword{importance}
\keyword{quantitative}
