% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UVs.R
\name{UVs}
\alias{UVs}
\title{Use Value (UV) index per species}
\source{
Albuquerque, U. P., R. F. P. Lucena, J. M. Monteiro, A. T. N. Florentino, and C. F. C. B. R. Almeida. 2006. Evaluating Two Quantitative Ethnobotanical Techniques. Ethnobotany Research and Applications 4:51–60. <http://hdl.handle.net/10125/237>
}
\usage{
UVs(data)
}
\arguments{
\item{data}{is an ethnobotany data set with column 1 'informant' and 2 'sp_name' as row identifiers of informants and of species names respectively.
The rest of the columns are the identified ethnobotany use categories. The data should be populated with counts of uses per person (should be 0 or 1 values).}
}
\description{
Allows users to calculate the use value (UV) index for each species in the data set (see Albuquerque et al. 2006).
}
\examples{

#Use built-in ethnobotany data example
UVs(ethnobotanydata)

#Generate random dataset of three informants uses for four species
eb_data <- data.frame(replicate(10,sample(0:1,20,rep=TRUE)))
names(eb_data) <- gsub(x = names(eb_data), pattern = "X", replacement = "Use_")  
eb_data$informant<-sample(c('User_1', 'User_2', 'User_3'), 20, replace=TRUE)
eb_data$sp_name<-sample(c('sp_1', 'sp_2', 'sp_3', 'sp_4'), 20, replace=TRUE)
UVs(eb_data)

}
\keyword{cultural}
\keyword{ethnobotany,}
\keyword{importance}
\keyword{quantitative}
