% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric_tests.R
\name{t_test}
\alias{t_test}
\title{An event study t-test.}
\usage{
t_test(list_of_returns, event_start, event_end)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{date}: a calendar date
    \item \code{weekday}: a day of the week
    \item \code{percentage}: a share of non-missing observations for a given
          day
    \item \code{mean}: an average abnormal return
    \item \code{t_test_stat}: a t-test statistic
    \item \code{t_test_signif}: a significance of the statistic
}
}
\description{
A classical t-test that examines each date in the event window.
}
\details{
Performs a t-test for the event study. The procedure of this test is
described in Boehmer et al. 1991, sometimes is called a cross-sectional test.
Assumes independence of securities, however is stable to event-induced
variance. This test examines the equality of the cross-sectional expected
value to zero. The standard deviation, which is used in this test, is simply
a cross-sectional standard deviation for a given day in the event window. It
calculates statistics even if event window and estimation period are
overlapped (intersect). The critical values are Student's t-distributed (no
approximation in limit). The significance levels of \eqn{\alpha} are 0.1,
0.05, and 0.01 (marked respectively by *, **, and ***).
}
\section{Warning}{
 This test strongly requires cross-sectional independence
and sensitive to the size of the sample.
}

\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^N100",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("ALV.DE", "CS.PA", "G.MI", "HNR1.HA", "HSX.L", "MUV2.DE",
             "RSA.L", "TOP.CO")
get_prices_from_tickers(tickers,
                        start = as.Date("2000-01-01"),
                        end = as.Date("2002-01-01"),
                        quote = "Close",
                        retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2001-03-26"),
                       estimation_end = as.Date("2001-09-10")) \%>\%
    t_test(event_start = as.Date("2001-09-11"),
           event_end = as.Date("2001-09-28"))
}
## The result of the code above is equivalent to:
data(securities_returns)
t_test(list_of_returns = securities_returns,
       event_start = as.Date("2001-09-11"),
       event_end = as.Date("2001-09-28"))

}
\references{
Boehmer E., Musumeci J., Poulsen A.B. \emph{Event-study
methodology under conditions of event-induced variance}. Journal of Financial
Economics, 30(2):253-272, 1991.
}
\seealso{
\code{\link{parametric_tests}}, \code{\link{brown_warner_1980}},
\code{\link{brown_warner_1985}}, \code{\link{patell}}, \code{\link{boehmer}},
and \code{\link{lamb}}.
}
