% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric_tests.R
\name{corrado_sign_test}
\alias{corrado_sign_test}
\title{Corrado's sign test (1992).}
\usage{
corrado_sign_test(list_of_returns, event_start, event_end)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{event_start}{an object of \code{Date} class giving the first date of
the event period.}

\item{event_end}{an object of \code{Date} class giving the last date of the
event period.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{date}: a calendar date
    \item \code{weekday}: a day of the week
    \item \code{percentage}: a share of non-missing observations for a given
          day
    \item \code{csign_stat}: a Corrado's sign test statistic
    \item \code{csign_signif}: a significance of the statistic
}
}
\description{
An event study nonparametric test described in Corrado and Zivney 1992.
}
\details{
Performs a nonparametric test for the event study, which is described in
Corrado and Zivney 1992. This test is similar to procedure, described in
Brown and Warner 1985 (t-ratio), but instead of using abnormal
returns, the test uses \eqn{G_{i,t} = sign(A_{i,t} - median(A_i))}.
\code{sign} and \code{median} are ones, which have the same definition as R
functions. For this test the estimation period and the event period must not
overlap, otherwise an error will be thrown. The sign test procedure avoids
the misspecification of tests, which assumes symmetry around zero of abnormal
returns (the median equals to zero). For a single day the performance of this
test is proven to be better than classical Brown and Warner's test (without
event-induced variance). This test is dominated by rank test. The
significance levels of \eqn{\alpha} are 0.1, 0.05, and 0.01 (marked
respectively by *, **, and ***).
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^N100",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("ALV.DE", "CS.PA", "G.MI", "HNR1.HA", "HSX.L", "MUV2.DE",
             "RSA.L", "TOP.CO")
get_prices_from_tickers(tickers,
                        start = as.Date("2000-01-01"),
                        end = as.Date("2002-01-01"),
                        quote = "Close",
                        retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2001-03-26"),
                       estimation_end = as.Date("2001-09-10")) \%>\%
    corrado_sign_test(event_start = as.Date("2001-09-11"),
                      event_end = as.Date("2001-09-28"))
}
## The result of the code above is equivalent to:
data(securities_returns)
corrado_sign_test(list_of_returns = securities_returns,
                  event_start =  as.Date("2001-09-11"),
                  event_end = as.Date("2001-09-28"))

}
\references{
Corrado C.J., Zivney T.L. \emph{The Specification and Power of
the Sign Test in Event Study Hypothesis Tests Using Daily Stock Returns}.
Journal of Financial and Quantitative Analysis, 27(3):465-478, 1992.
}
\seealso{
\code{\link{nonparametric_tests}}, \code{\link{sign_test}},
\code{\link{generalized_sign_test}}, \code{\link{rank_test}},
\code{\link{modified_rank_test}}, and \code{\link{wilcoxon_test}}.
}
