% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_tidy.R
\name{estimatr_tidiers}
\alias{estimatr_tidiers}
\alias{tidy.lm_robust}
\alias{tidy.iv_robust}
\alias{tidy.difference_in_means}
\alias{tidy.horvitz_thompson}
\alias{tidy.lh_robust}
\alias{tidy.lh}
\title{Tidy an estimatr object}
\usage{
\method{tidy}{lm_robust}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{tidy}{iv_robust}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{tidy}{difference_in_means}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{tidy}{horvitz_thompson}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{tidy}{lh_robust}(x, ...)

\method{tidy}{lh}(x, ...)
}
\arguments{
\item{x}{An object returned by one of the estimators}

\item{conf.int}{Logical indicating whether or not to include a
confidence interval in the tidied output. Defaults to ‘FALSE’.}

\item{conf.level}{The confidence level to use for the confidence
interval if ‘conf.int = TRUE’. Must be strictly greater than 0 and less
than 1. Defaults to 0.95, which corresponds to a 95 percent confidence
interval.}

\item{...}{extra arguments (not used)}
}
\value{
A data.frame with columns for coefficient names, estimates, standard
errors, confidence intervals, p-values, degrees of freedom, and the
name of the outcome variable
}
\description{
Tidy an estimatr object
}
\seealso{
\code{\link[generics:tidy]{generics::tidy()}}, \code{\link[=lm_robust]{lm_robust()}}, \code{\link[=iv_robust]{iv_robust()}},  \code{\link[=difference_in_means]{difference_in_means()}}, \code{\link[=horvitz_thompson]{horvitz_thompson()}}
}
\concept{estimatr tidiers}
