% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esList.R
\name{esList}
\alias{esList}
\title{esList}
\usage{
esList(dfList, RELEVANTVN_ES = NULL)
}
\arguments{
\item{dfList}{a list. Each element of the list must be a data.frame. Each data.frame is a separate raw ESM dataset/an ESM questionnaire version. If there is just one ESM version the list therefore contains one data.frame.}

\item{RELEVANTVN_ES}{a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.}
}
\value{
A named list of the ESM datasets, where each list name is equal to the name of the respective ESM questionnaire version.
}
\description{
esList holds all separate raw ESM datasets in one list, which is an R-built-in data structure.
}
\details{
The separate raw ESM datasets are still separated in the list. Each list element is named according to the survey version as specified by the content of the respective column name in each ESM dataset.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute esList. Start --------------------
# Generate argument RELEVANTVN_ES
relEs <- relevantESVN(svyName="survey_name", IMEI="IMEI",
STARTDATE="start_date", STARTTIME="start_time",
ENDDATE="end_date", ENDTIME="end_time")
imeiNumbers <- as.character(referenceDf$imei)
surveyNames <- c("morningTestGroup", "dayTestGroup", "eveningTestGroup",
"morningControlGroup", "dayControlGroup", "eveningControlGroup")
RELEVANT_ES <- setES(4, imeiNumbers, surveyNames, relEs)
RELEVANTVN_ES <- RELEVANT_ES[["RELEVANTVN_ES"]]
# Prerequisites in order to execute esList. End ----------------------
# ------------------------------------------------------
# Run function 5 of 28; see esmprep functions' hierarchy.
# ------------------------------------------------------
# 6 exemplary raw ESM (sub-)datasets.
esLs <- esList(list(morningControl, dayControl, eveningControl,
morningTest, dayTest, eveningTest), RELEVANTVN_ES)
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 5 of 28).
}
