% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_correlation.R
\name{signal_correlation}
\alias{signal_correlation}
\title{Calculate signal cross-correlation values}
\usage{
signal_correlation(data, window = 200)
}
\arguments{
\item{data}{\code{eseis} object, \code{list} object with data sets to be 
processed. The list can contain numeric vectors or eseis objects. It is 
assumed that all vectors have the same length.}

\item{window}{\code{Numeric} value, size of the running window, in 
number of samples}
}
\value{
\code{Numeric} running cross-correlation of the input signals.
}
\description{
This function calculates the running cross-correlation of two or more 
seismic signas and returns that characteristic function.
}
\examples{

## calculate cross-correlation
s_cc <- signal_correlation(data = list(a = runif(1000),
                                       b = runif(1000),
                                       c = runif(1000)),
                           window = 200)

}
\author{
Michael Dietze
}
\keyword{eseis}
