% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_convert.R
\name{time_convert}
\alias{time_convert}
\title{Convert Julian Day to Date and vice versa}
\usage{
time_convert(input, output, timezone = "UTC", year)
}
\arguments{
\item{input}{\code{Numeric} vector, input time Supported formats are 
\code{YYYY-MM-DD}, \code{JD} and \code{POSIXct}.}

\item{output}{\code{Numeric} vector, output time. Supported formats are 
\code{YYYY-MM-DD}, \code{JD} and \code{POSIXct}.}

\item{timezone}{\code{Character} vector, time zone of the output date. 
Default is \code{"UTC"}.}

\item{year}{\code{Character} vector, year of the date. Only used when 
\code{input} is \code{JD}. If omitted, the current year is used.}
}
\value{
\code{Numeric} vector,
}
\description{
The function converts a Julian Day value to a date, to \code{POSIXct} if a 
year is provided, otherwise to \code{POSIXlt}.
}
\examples{

## convert Julian Day 18 to POSIXct
time_convert(input = 18, output = "POSIXct")

## convert Julian Day 18 to yyyy-mm-dd
time_convert(input = 18, output = "yyyy-mm-dd")

## convert yyyy-mm-dd to Julian Day
time_convert(input = "2016-01-18", output = "JD")

## convert a vector of Julian Days to yyyy-mm-dd
time_convert(input = 18:21, output = "yyyy-mm-dd")
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
