% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_psdsummary.R
\name{aux_psdsummary}
\alias{aux_psdsummary}
\title{Generate spectrograms for seismic stations at different time periods}
\usage{
aux_psdsummary(
  station,
  component = "BHZ",
  period,
  output = c("daily", "weekly", "monthly", "total"),
  input_dir,
  output_dir,
  aggregate = c(1, 5),
  n_dates = 2000,
  jpg_dim = c(4444, 2500, 300, 90),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{station}{\code{Character} value, seismic station ID, which must
correspond to the ID in the file name of the data directory structure 
(cf. \code{aux_organisecubefiles()}).}

\item{component}{\code{Character} value, seismic component, which must
correspond to the component name in the file name of the data directory  
structure (cf. \code{aux_organisecubefiles()}). Default is 
\code{"BHZ"} (vertical component of a sac file).}

\item{period}{\code{POSIXct} vector of length two, time period to be 
processed.}

\item{output}{\code{Character} vector, output PSD types. One or more out 
of \code{"daily"}, \code{"weekly"}, \code{"monthly"}, \code{"total"}. 
Default is \code{c("daily", "weekly", "monthly", "total")}.}

\item{input_dir}{\code{Character} value, path to directory where the 
seismic files are stored.}

\item{output_dir}{\code{Character} value, path to directory where PSD
image files are saved to.}

\item{aggregate}{\code{Numeric} vector of length two, aggregation factors 
for the processed PSD matrics. First entry denotes time aggregation, 
second entry frequency aggregation. Default is \code{c(1, 5)}.}

\item{n_dates}{\code{Numeric} value, final number of spectra per output 
PSD. Default is \code{2000}.}

\item{jpg_dim}{\code{Numeric} vector of length four, JPEG image properties 
in the form \code{c(width, height, resolution, quality)}. Default is 
\code{c(4444, 2500, 300, 90)}.}

\item{verbose}{\code{Logical} value, optional screen output of processing 
progress. Default is \code{FALSE}.}

\item{\dots}{Additional arguments passed to different functions. See 
details section for default values.}
}
\value{
A set of JPEG images wirtten to disk
}
\description{
The function generates a set of spectrograms (PSDs) for all seismic
stations provided, for daily, weekly, monthly and total time periods. 
It depends on seismic files being organised in a coherent structure as, 
for example, generated by \code{aux_Organisecubefiles}.
}
\details{
The function calls a series of other functions, partly with modified 
default values, which can be changed by the ...-argument. By default,
the seismic files are imported as eseis objects using 
\code{aux_getevent(..., eseis = TRUE)}. The signals are deconvolved with
\code{signal_deconvolve()} using the default options, i.e., 
\code{sensor = "TC120s"} and \code{logger = "Cube3extBOB"}.
Then, the signals are bandpass filtered with \code{signal_filter}, using 
\code{f = c(1, 90)}. The PSDs are calculated with \code{signal_spectrogram} 
using \code{Welch = TRUE}, \code{window = 90} and \code{window_sub = 30}. 

This and all other aux-functions are primarily written for internal use 
amongst the GFZ Geomorphology Section group members and their usual data 
handling scheme. Thus, they may be of limited use when adopted for other 
scopes. However, many of these functions are internally consistent in 
usage.
}
\examples{

\dontrun{

## PSD generation with minimum input arguments
aux_psdsummary(station = c("STA01", "STA02"), 
               period = as.POSIXct(x = c("2017-04-01",
                                         "2017-04-03"), 
                                   tz = "UTC"), 
               input_dir = "~/data/seismic/sac/")

## PSD generation with some more arguments
aux_psdsummary(station = c("STA01", "STA02"), 
               component = "BHZ",
               period = as.POSIXct(x = c("2017-04-01",
                                         "2017-04-03"), 
                                   tz = "UTC"), 
               output = c("daily", "monthly"),
               input_dir = "~/data/seismic/sac/",
               aggregate = c(2, 10), 
               n_dates = 1000,
               jpg_dim = c(1600, 900, 300, 50), 
               verbose = TRUE)
}

}
\author{
Michael Dietze
}
\keyword{eseis}
