% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_diamond_ratio.R
\name{CI_diamond_ratio}
\alias{CI_diamond_ratio}
\title{Estimate the diamond ratio for a meta-analytic effect, a measure of
heterogeneity}
\source{
Cairns, Maxwell, Geoff Cumming, Robert Calin‐Jageman, and Luke A.
Prendergast. “The Diamond Ratio: A Visual Indicator of the Extent of
Heterogeneity in Meta‐analysis.” \emph{British Journal of Mathematical and
Statistical Psychology} 75, no. 2 (May 2022): 201–19.
https://doi.org/10.1111/bmsp.12258.
}
\usage{
CI_diamond_ratio(RE, FE, vi, conf_level = 0.95)
}
\arguments{
\item{RE}{metafor object with random effects result}

\item{FE}{metafor object with fixed effects result}

\item{vi}{vector of effect size variances}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}
}
\value{
Returns a list with 3 properties:
\itemize{
\item diamond_ratio
\item LL - lower limit of the conf_level\% CI, Sub-Q approach
\item UL - upper limit of the conf_level\% CI, Sub-Q approach
\item LL_bWT_DL  - lower limit of the conf_level\% CI, bWT-DL approach
\item UL_bWT_DL  - upper limit of the conf_level\% CI, bWT-DL approach
}
}
\description{
\code{CI_diamond_ratio} returns the diamond ratio and CI for a
meta-analytic effect, the ratio of the random-effects CI width to the
fixed-effects CI width.  The diamond ratio is a measure of effect-size
heterogeneity.
}
\details{
Calculation of the CI is based on code provided by Maxwell Cairns
(see Cairns et al., 2022).  Specifically, this function implements what
Cairns et al (2022) called the Sub-Q approach, which
provides the best CI coverage in simulations.  For comparison, this
function also returns the CI produced by the bWT-DL approach (which
generally has worse performance).
}
\examples{
mydata <- esci::data_mccabemichael_brain

# Use esci to obtain effect sizes and sample variances, storing only raw_data
mydata <- esci::meta_mdiff_two(
  data = mydata,
  comparison_means = "M Brain",
  comparison_ns = "n Brain",
  comparison_sds = "s Brain",
  reference_means = "M No Brain",
  reference_ns = "n No Brain",
  reference_sds = "s No Brain",
  random_effects = FALSE
)$raw_data

# Conduct fixed effects meta-analysis
FE <- metafor::rma(
  data = mydata,
  yi = effect_size,
  vi = sample_variance,
  method="FE"
)
# Conduct random effect meta-analysis
RE <- metafor::rma(
  data = mydata,
  yi = effect_size,
  vi = sample_variance,
  method="DL"
)

# Get the diamond ratio
res <- esci::CI_diamond_ratio(
  RE = RE,
  FE = FE,
  vi = mydata$sample_variance
)

}
