% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pdiff_ind_contrast.R
\name{estimate_pdiff_ind_contrast}
\alias{estimate_pdiff_ind_contrast}
\title{Estimates for a multi-group study with a categorical outcome
variable}
\usage{
estimate_pdiff_ind_contrast(
  data = NULL,
  outcome_variable = NULL,
  grouping_variable = NULL,
  cases = NULL,
  ns = NULL,
  contrast = NULL,
  case_label = 1,
  grouping_variable_levels = NULL,
  outcome_variable_name = "My outcome variable",
  grouping_variable_name = "My grouping variable",
  conf_level = 0.95,
  count_NA = FALSE
)
}
\arguments{
\item{data}{For raw data - a data frame or tibble}

\item{outcome_variable}{For raw data - The column name of the outcome
variable which is a factor, or a vector that is a factor}

\item{grouping_variable}{For raw data - The column name of the grouping
variable which is a factor, or a vector that is a factor}

\item{cases}{For summary data - A numeric vector of 2 or more event counts,
each an integer >= 0}

\item{ns}{For summary data - A numeric vector of sample sizes, same length
as counts, each an integer >= corresponding event count}

\item{contrast}{A vector of group weights, same length as number of groups.}

\item{case_label}{An optional numeric or character label
For summary data, used as the label and defaults to 'Affected'.  For raw
data, used to specify the level used for the proportion.}

\item{grouping_variable_levels}{For summary data - An optional vector of
group labels, same length as cases}

\item{outcome_variable_name}{Optional friendly name for the outcome variable.
Defaults to 'My outcome variable' or the outcome variable column name if a
data frame is passed.}

\item{grouping_variable_name}{Optional friendly name for the grouping
variable.  Defaults to 'My grouping variable' or the grouping variable
column name if a data.frame is passed.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{count_NA}{Logical to count NAs (TRUE) in total N or not (FALSE)}
}
\value{
Returns object of class esci_estimate
\itemize{
\item \strong{es_proportion_difference}
\itemize{
\item \emph{type} -
\item \emph{outcome_variable_name} -
\item \emph{case_label} -
\item \emph{grouping_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{effect_size_adjusted} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{es_odds_ratio}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{case_label} -
\item \emph{grouping_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{SE} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{overview}
\itemize{
\item \emph{grouping_variable_name} -
\item \emph{grouping_variable_level} -
\item \emph{outcome_variable_name} -
\item \emph{outcome_variable_level} -
\item \emph{cases} -
\item \emph{n} -
\item \emph{P} -
\item \emph{P_LL} -
\item \emph{P_UL} -
\item \emph{P_SE} -
\item \emph{P_adjusted} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{es_phi}
\itemize{
\item \emph{grouping_variable_name} -
\item \emph{outcome_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{SE} -
\item \emph{LL} -
\item \emph{UL} -
}
}
}
\description{
Returns object
\code{estimate_pdiff_ind_contrast} is suitable for a multi-group design
(between subjects) with a categorical outcome variable.  It accepts
a user-defined set of contrast weights that allows estimation of any
1-df contrast.  It can express estimates as a difference in proportions
and as an odds ratio (2-group designs only).  You can pass raw data or
summary data.
}
\details{
Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_mdiff]{plot_mdiff()}} and you can test hypotheses with
\code{\link[=test_mdiff]{test_mdiff()}}.

The estimated proportion differences are from \code{\link[statpsych:ci.lc.prop.bs]{statpsych::ci.lc.prop.bs()}}.

The estimated odds ratios (if returned) are from \code{\link[statpsych:ci.oddsratio]{statpsych::ci.oddsratio()}}.
}
\examples{
# From raw data
data("data_campus_involvement")

estimate_from_raw <- esci::estimate_pdiff_ind_contrast(
  esci::data_campus_involvement,
  CommuterStatus,
  Gender,
  contrast = c("Male" = -1, "Female" = 1)
)

# To visualize the estimate
myplot_from_raw <- esci::plot_pdiff(estimate_from_raw)

# To conduct a hypothesis test
res_htest_from_raw <- esci::test_pdiff(estimate_from_raw)


# From summary data
estimate_from_summary <- esci::estimate_pdiff_ind_contrast(
  cases = c(78, 10),
  ns = c(252, 20),
  case_label = "egocentric",
  grouping_variable_levels = c("Original", "Replication"),
  contrast = c(-1, 1),
  conf_level = 0.95
)

# To visualize the estimate
myplot_from_summary <- esci::plot_pdiff(estimate_from_summary)

# To conduct a hypothesis test
res_htest_from_summary <- esci::test_pdiff(estimate_from_summary)


}
