% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{Extract.errors}
\alias{Extract.errors}
\alias{[.errors}
\alias{[[.errors}
\alias{[<-.errors}
\alias{[[<-.errors}
\title{Extract or Replace Parts of an Object}
\usage{
\method{[}{errors}(x, ...)

\method{[[}{errors}(x, ...)

\method{[}{errors}(x, ...) <- value

\method{[[}{errors}(x, ...) <- value
}
\arguments{
\item{x}{object from which to extract element(s) or in which to replace element(s).}

\item{...}{additional arguments to be passed to base methods
(see \code{\link[base]{Extract}}).}

\item{value}{typically an array-like \R object of a similar class as \code{x}.}
}
\description{
S3 operators to extract or replace parts of \code{errors} objects.
}
\examples{
x <- set_errors(1:3, 0.1)
y <- set_errors(4:6, 0.2)
(z <- rbind(x, y))
z[2, 2]
z[2, 2] <- -1
errors(z[[1, 2]]) <- 0.8
z[, 2]

}
