context("conversion")

test_that("errors objects are correctly created", {
  xval <- c(-1, 0, 1)
  xerr <- c(0.2, 0.1, 0.18)

  x <- xval
  errors(x) <- xerr
  expect_true(inherits(x, "errors"))
  expect_equal(as.numeric(x), xval)
  expect_equal(errors(x), xerr)
  expect_equal(errors(xval), rep(0, 3))
  expect_equal(attr(x, "errors"), xerr)
  expect_equal(x, set_errors(xval, xerr))
  expect_equal(x, as.errors(xval, xerr))
  expect_equal(xval-xerr, errors_min(x))
  expect_equal(xval+xerr, errors_max(x))
  expect_equal(x, as.data.frame(x)$x)

  errors(x) <- xerr/2
  expect_equal(x, set_errors(x, xerr/2))
  expect_equal(x, as.errors(x, xerr/2))
})

test_that("defaults work as expected", {
  xval <- c(0, NA, NaN, Inf)
  x <- set_errors(xval)
  expect_equal(as.numeric(x), xval)
  expect_equal(errors(x), xval)
})

test_that("errors can be defined as integers", {
  x <- set_errors(1:3, 1:3)
  expect_equal(errors(x), 1:3)
})

test_that("type_sum is available for errors objects", {
  skip_if_not_installed("tibble")
  library(tibble)
  expect_equal(type_sum(set_errors(1, 0.1)), "[(err)]")
})

test_that("pillar_shaft is available for errors objects", {
  skip_if_not_installed("pillar")
  library(pillar)
  expect_equal(as.character(pillar_shaft(set_errors(1, 0.1))),
               paste0("1.0", style_subtle("(1)")))
})

test_that("errors are dropped", {
  x1 <- set_errors(1:3, 0.1)
  x2 <- set_errors(x1, NULL)
  x3 <- drop_errors(x1)
  errors(x1) <- NULL
  expect_true(!inherits(x1, "errors"))
  expect_true(!inherits(x2, "errors"))
  expect_true(!inherits(x3, "errors"))
  expect_null(attr(x1, "errors"))
  expect_null(attr(x2, "errors"))
  expect_null(attr(x3, "errors"))
})
