% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{error_interval.default}
\alias{error_interval.default}
\title{Error Intervals}
\usage{
\method{error_interval}{default}(phi, s = 0.05, dist = "n", tol = 10^-6,
  ...)
}
\arguments{
\item{phi}{a vector with residual values used to compute the error interval.}

\item{s}{confidence level, e,g. s=0.05 for the standard 95 percent confidence interval.}

\item{dist}{assumed distribution for the noise in the data.}

\item{tol}{used to normalize residual values to (0,1) when beta is the
assumed distribution. The formula used is abs(phi)/(max(abs(phi))+tol).}

\item{...}{additional arguments to be passed to the low level
error_interval building functions (see below).}
}
\value{
Returns an object of class \code{c("error_interval","list")}
with information regarding the error intervals built.
}
\description{
\code{error_interval.default} creates an object of class
 \code{c("error_interval", "list")}.
}
\examples{
error_interval(rnorm(10))

error_interval(rnorm(10),s=0.1,dist="lm")
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}

