% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{error_interval}
\alias{as.error_interval}
\alias{error_interval}
\alias{is.error_interval}
\title{Error Intervals}
\usage{
error_interval(phi, s = 0.05, dist = "n", tol = 10^-6, ...)

as.error_interval(x)

is.error_interval(x)
}
\arguments{
\item{phi}{a vector with residual values used to compute the error interval.}

\item{s}{confidence level, e,g. s=0.05 for the standard 95 percent confidence interval.}

\item{dist}{assumed distribution for the noise in the data.}

\item{tol}{used to normalize residual values to (0,1) when beta is the
assumed distribution. The formula used is abs(phi)/(max(abs(phi))+tol).}

\item{...}{additional arguments to be passed to the low level
error_interval building functions (see below).}

\item{x}{an R object.}
}
\value{
\code{error_interval} returns an object of class \code{c("error_interval","list")}
with information regarding the error intervals built.

\code{as.error_interval} returns an object of class
\code{c("error_interval",class(x))} with information contained in x if possible.
Returns x otherwise.

\code{is.error_interval}returns TRUE if x is an R object with
\code{"error_interval"} as one of its classes. FALSE otherwise.
}
\description{
\code{error_interval} creates an object of class
 \code{c("error_interval", "list")}.

\code{as.error_interval} attempts to coerce its argument \code{x} into an
object of class \code{c("error_interval", class(x))}. If this is not possible
\code{x} is returned unchanged.

\code{is.error_interval} returns TRUE if x is an R object with
\code{"error_interval"} as one of its classes. It returns FALSE otherwise.
}
\examples{
error_interval(rnorm(100))

error_interval(rnorm(100),s=0.1,dist="lm")


l<-list(min=-1,max=1,err=0.05,s=0.1,dist="n",phi=rnorm(1000))
as.error_interval(l)

v<-c("a","b")
as.error_interval(v)


l<-list(min=-1,max=1,err=0.05,s=0.1,dist="n",phi=rnorm(1000))
is.error_interval(l)
res<-as.error_interval(l)
is.error_interval(res)
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}

