% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Butterfly.R
\name{butterfly}
\alias{butterfly}
\title{Generate a butterfly plot for a specified condition}
\usage{
butterfly(data, electrodes, stim = 1)
}
\arguments{
\item{data}{A data frame in the format returned from \code{\link{load.data}}}

\item{electrodes}{A single value or concatenation of several values (to be averaged)
indicating which electrodes to include in generating the plot. At this time, if the
raw data files imported using \code{\link{load.data}}) do not have a header, you
must include a capital "V" in front of the number and enclose each electrode in quotes.
(For example, electrodes = "V78", or electrodes = c("V78", "V76").)}

\item{stim}{An integer specifying which condition to plot. Conditions are numbered in the
  order in which they are imported with \code{load.data}.  The plot title will specify
  the name of the condition to avoid confusion.}
}
\value{
A single butterfly plot for the condition specified with \code{stim}.
}
\description{
\code{butterfly} plots all individual waveforms for the condition specified by the
  \code{stim} argument (i.e., a butterfly plot). The grand average waveform is also plotted,
  using a red line.
}
\details{
Single electrodes can be passed to the package functions, or several electrodes can
  be provided (i.e., when using dense arrays) and those electrodes will be averaged
  together as a single electrode.
}
\examples{
butterfly(ERPdata, electrodes = "V78", stim = 1)
}
\author{
Travis Moore
}

