% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Individual.R
\name{individual}
\alias{individual}
\title{Plot individual, averaged waveforms for all loaded conditions}
\usage{
individual(data, electrodes)
}
\arguments{
\item{data}{A data frame in the format returned from \code{\link{load.data}}}

\item{electrodes}{A single value or concatenation of several values (to be averaged)
  indicating which electrodes to include in generating the plot. At this time, if the
  raw data files imported using \code{\link{load.data}}) do not have a header, you
  must include a capital "V" in front of the number and enclose each electrode in quotes.
  (For example, electrodes = "V78", or electrodes = c("V78", "V76").)}
}
\value{
Multiple plots (1 per subject) with color-coded, labeled legends
}
\description{
\code{individual} plots individual, averaged waveforms for each condition present in the
  data frame you provide.  A color-coded, labeled legend is generated with the plot for ease of
  identification of each condition.
}
\details{
\code{individual} will generate a separate plot of averaged waveforms for each
  subject in the data frame you provide.  For ease of use on the user end, colors are
  automatically assigned. The legend labels display the values provided in the \code{condition}
  argument of \code{\link{load.data}}.

  Single electrodes can be passed to the package functions,
  or several electrodes can be provided (i.e., when using dense arrays) and those electrodes
  will be averaged together as a single electrode.
}
\examples{
# Create average waveform plots for each subject
individual(ERPdata, electrodes = "V78")
}
\author{
Travis Moore
}

