% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single.R
\name{check_string}
\alias{check_string}
\title{Check If Argument Is Single Character}
\usage{
check_string(
  x,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  ...
)
}
\arguments{
\item{x}{The argument to check, which can be any object.}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. By default, this is generated automatically.
Can be turned off with \code{character(0)}.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=Statement]{Statement()}}. By default, this is left empty.}

\item{...}{Optional. Additional arguments passed to \code{\link[rlang:abort]{rlang::abort()}},
which is called internally.}
}
\value{
An invisible \code{NULL} if the argument is valid, or an error message
is generated.
}
\description{
Check if an argument is a single character. and if not,
generate an error message.

Can be used to check argument names, for example.
}
\examples{
x <- "a"
check_string(x)

\dontrun{
# `x` must have type character
x <- c
check_string(x)

# `x` must have length 1
x <- c("a", "b")
check_string(x)

# `NA_character_` is not acceptable
x <- NA_character_
check_string(x)
}
}
\seealso{
"Examples" section in \code{\link[=check_type]{check_type()}} for how to customize
error message and how to add and retrieve additional arguments.

\code{vignette("erify")} for a gentle introduction to this package.
}
