% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R,
%   R/InitWtErgmTerm.operator.R
\name{Label-ergmTerm}
\alias{Label-ergmTerm}
\alias{InitErgmTerm.Label}
\alias{InitWtErgmTerm.Label}
\title{Modify terms' coefficient names}
\usage{
# binary: Label(formula, label, pos)

# valued: Label(formula, label, pos)
}
\arguments{
\item{formula}{a one-sided \code{\link[=ergm]{ergm()}}-style formula with the terms to be evaluated}

\item{label}{a character vector specifying the label for the terms, a \code{\link{list}} of two character vectors (see Details), or a function through which term names are mapped (or a \code{\link[purrr:as_mapper]{as_mapper}} -style formula).}

\item{pos}{controls how \code{label} modifies the term names: one of \code{"prepend"} , \code{"replace"} , \code{"append"} , or \code{"("} , with the latter wrapping the term names in parentheses like a function call with name specified by \code{label} .}
}
\description{
This operator evaluates \code{formula} without modification, but modifies its coefficient and/or parameter names based on \code{label} and \code{pos} .
}
\details{
If \code{pos == "replace"}:
\itemize{
\item Elements for which \code{is.na(label) == TRUE} are preserved.
\item If the model is curved, \verb{label=} can be a either function/mapper
or a \code{\link{list}} with two elements, the first element giving the
curved (model) parameter names and second giving the canonical
parameter names. \code{NULL} leaves the respective name unchanged.
}
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "Label", "subsection")}
}
\concept{operator}
