% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Goeyvaerts}
\alias{Goeyvaerts}
\title{A sample of within-household contact networks in Flanders and Brussels}
\format{
An object of class \code{list} of length 318.
}
\source{
The data were collected and by \insertCite{GoSa18h;textual}{ergm.multi} and
curated by Pietro Coletti.
}
\usage{
data(Goeyvaerts)
}
\description{
This is a list of 318 \code{\link{network}} objects derived from contact
diary data collected by by \insertCite{GoSa18h;textual}{ergm.multi}. The
study recruited households in Flanders and Brussels-Capital region
with at least one child 12 or under. The networks are symmetrized.
}
\section{Nonstandard Network Attributes}{
 \describe{

\item{\code{included}}{(logical) whether the network was included in
Goeyvaerts's analysis. (Two were excluded.)}

\item{\code{weekday}}{(logical) whether the contact diary on which the
network is based was collected on a weekday, as opposed to
weekend.}

}
}

\section{Nonstandard Vertex Attributes}{
 \describe{

\item{\code{age}}{(numeric) the household member's age.}

\item{\code{gender}}{(character) the household member's gender (\code{"F"}/\code{"M"}).}

\item{\code{role}}{(character) the household member's inferred role (\code{"Father"}/\code{"Mother"}/\code{"Child"}/\code{"Grandmother"}).}

}
}

\section{Licenses and Citation}{
 When publishing results obtained
using this data set, the original authors
\insertCite{GoSa18h}{ergm.multi} should be cited, along with this
\R package.
}

\references{
\insertAllCited{}
}
\seealso{
\code{vignette("Goeyvaerts_reproduction")} for a vignette reproducing the Goeyvaerts analysis and performing diagnostics
}
\keyword{datasets}
