% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-era.R
\name{era_parameters}
\alias{era_parameters}
\alias{era_label}
\alias{era_epoch}
\alias{era_name}
\alias{era_unit}
\alias{era_scale}
\alias{era_direction}
\title{Get parameters of an era}
\usage{
era_label(x)

era_epoch(x)

era_name(x)

era_unit(x)

era_scale(x)

era_direction(x)
}
\arguments{
\item{x}{An \code{era} object.}
}
\value{
Value of the parameter.
}
\description{
Extracts a specific parameter from an era object.
}
\details{
The available parameters are:
\itemize{
\item \strong{label} – unique, abbreviated label of the era, e.g. "cal BP"
\item \strong{epoch} – year of origin of the era, e.g. 1950 for Before Present
\item \strong{name} – full name of the era, e.g. "calendar years Before Present"
\item \strong{unit} – unit of years used, an \code{\link[=era_year]{era_year()}} object
\item \strong{scale} – multiple of years used, e.g. 1000 for ka/kiloannum
\item \strong{direction} – whether years are counted "backwards" or "forwards" from the epoch
#'
}
}
\examples{
x <- era("cal BP")
era_name(x)
}
\seealso{
Other era helper functions: 
\code{\link{era_year_parameters}},
\code{\link{era_year}},
\code{\link{era}},
\code{\link{is_era_year}()},
\code{\link{is_era}()},
\code{\link{is_yr}()},
\code{\link{this_year}()}
}
\concept{era helper functions}
